/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.web;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleResponsibilityBo;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kns.web.struts.form.KualiForm;

public class DelegateRuleForm
extends KualiForm {
    private static final long serialVersionUID = 5412969516727713859L;
    private String parentRuleId;
    private String parentResponsibilityId;
    private RuleBaseValues parentRule;
    private RuleResponsibilityBo parentResponsibility;
    private List<String> reviewers = new ArrayList<String>();
    private List<String> responsibilityTypes = new ArrayList<String>();
    private List<String> actionRequestCodes = new ArrayList<String>();

    public String getParentRuleId() {
        return this.parentRuleId;
    }

    public void setParentRuleId(String parentRuleId) {
        this.parentRuleId = parentRuleId;
    }

    public String getParentResponsibilityId() {
        return this.parentResponsibilityId;
    }

    public void setParentResponsibilityId(String parentResponsibilityId) {
        this.parentResponsibilityId = parentResponsibilityId;
    }

    public RuleBaseValues getParentRule() {
        return this.parentRule;
    }

    public void setParentRule(RuleBaseValues parentRule) {
        if (this.parentRule != null && parentRule != null && this.parentResponsibility != null && !StringUtils.equals((String)this.parentRule.getId(), (String)parentRule.getId())) {
            this.parentResponsibility = null;
            this.parentResponsibilityId = null;
        }
        this.parentRule = parentRule;
    }

    public RuleResponsibilityBo getParentResponsibility() {
        return this.parentResponsibility;
    }

    public void setParentResponsibility(RuleResponsibilityBo parentResponsibility) {
        this.parentResponsibility = parentResponsibility;
    }

    public List<String> getReviewers() {
        return this.reviewers;
    }

    public void setReviewers(List<String> reviewers) {
        this.reviewers = reviewers;
    }

    public List<String> getResponsibilityTypes() {
        return this.responsibilityTypes;
    }

    public void setResponsibilityTypes(List<String> responsibilityTypes) {
        this.responsibilityTypes = responsibilityTypes;
    }

    public List<String> getActionRequestCodes() {
        return this.actionRequestCodes;
    }

    public void setActionRequestCodes(List<String> actionRequestCodes) {
        this.actionRequestCodes = actionRequestCodes;
    }

    public String getRuleDescription() {
        if (this.getParentRule() == null) {
            return "";
        }
        return this.getParentRule().getDescription();
    }

    public void populate(HttpServletRequest request) {
        super.populate(request);
        this.reviewers.clear();
        this.responsibilityTypes.clear();
        this.actionRequestCodes.clear();
        if (this.getParentRuleId() != null) {
            this.setParentRule(KEWServiceLocator.getRuleService().findRuleBaseValuesById(this.getParentRuleId()));
        }
        if (this.getParentResponsibilityId() != null && this.getParentRule() != null) {
            for (RuleResponsibilityBo responsibility : this.getParentRule().getRuleResponsibilities()) {
                if (!responsibility.getResponsibilityId().equals(this.getParentResponsibilityId())) continue;
                this.setParentResponsibility(responsibility);
                break;
            }
        }
        if (this.getParentRule() != null) {
            for (RuleResponsibilityBo responsibility : this.getParentRule().getRuleResponsibilities()) {
                if ("F".equals(responsibility.getRuleResponsibilityType())) {
                    Principal principal = KEWServiceLocator.getIdentityHelperService().getPrincipal(responsibility.getRuleResponsibilityName());
                    if (principal != null) {
                        this.reviewers.add(principal.getPrincipalName());
                    }
                    this.responsibilityTypes.add("PERSON");
                } else if ("G".equals(responsibility.getRuleResponsibilityType())) {
                    Group group = KimApiServiceLocator.getGroupService().getGroup(responsibility.getRuleResponsibilityName());
                    if (group != null) {
                        this.reviewers.add(group.getNamespaceCode() + " " + group.getName());
                    }
                    this.responsibilityTypes.add("GROUP");
                } else if ("R".equals(responsibility.getRuleResponsibilityType())) {
                    this.reviewers.add(responsibility.getResolvedRoleName());
                    this.responsibilityTypes.add("ROLE");
                } else {
                    throw new RiceRuntimeException("Encountered a responsibility with an invalid type, type value was " + responsibility.getRuleResponsibilityType());
                }
                this.actionRequestCodes.add((String)KewApiConstants.ACTION_REQUEST_CODES.get(responsibility.getActionRequestedCd()));
            }
        }
    }
}

