/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.lookup;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.permission.GenericPermissionBo;
import org.kuali.rice.kim.impl.permission.PermissionBo;
import org.kuali.rice.kim.impl.permission.UberPermissionBo;
import org.kuali.rice.kim.impl.role.RoleBo;
import org.kuali.rice.kim.impl.role.RolePermissionBo;
import org.kuali.rice.kim.lookup.RoleMemberLookupableHelperServiceImpl;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.lookup.CollectionIncomplete;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.LookupService;
import org.kuali.rice.krad.util.UrlFactory;

public class PermissionLookupableHelperServiceImpl
extends RoleMemberLookupableHelperServiceImpl {
    private static final long serialVersionUID = -3578448525862270477L;
    private transient LookupService lookupService;
    private transient RoleService roleService;
    private volatile String genericPermissionDocumentTypeName;

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        ArrayList<HtmlData> htmlDataList = new ArrayList<HtmlData>();
        if (this.allowsMaintenanceEditAction(businessObject = new GenericPermissionBo((PermissionBo)((UberPermissionBo)businessObject)))) {
            htmlDataList.add((HtmlData)this.getUrlData(businessObject, "edit", pkNames));
        }
        if (this.allowsMaintenanceNewOrCopyAction()) {
            htmlDataList.add((HtmlData)this.getUrlData(businessObject, "copy", pkNames));
        }
        return htmlDataList;
    }

    protected String getActionUrlHref(BusinessObject businessObject, String methodToCall, List pkNames) {
        Properties parameters = new Properties();
        parameters.put("methodToCall", methodToCall);
        parameters.put("businessObjectClassName", businessObject.getClass().getName());
        parameters.put("overrideKeys", "id");
        parameters.put("cpKys", "id");
        if (StringUtils.isNotBlank((String)this.getReturnLocation())) {
            parameters.put("returnLocation", this.getReturnLocation());
        }
        parameters.putAll((Map<?, ?>)this.getParametersFromPrimaryKey(businessObject, pkNames));
        return UrlFactory.parameterizeUrl((String)"maintenance.do", (Properties)parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getMaintenanceDocumentTypeName() {
        String g = this.genericPermissionDocumentTypeName;
        if (g == null) {
            PermissionLookupableHelperServiceImpl permissionLookupableHelperServiceImpl = this;
            synchronized (permissionLookupableHelperServiceImpl) {
                g = this.genericPermissionDocumentTypeName;
                if (g == null) {
                    this.genericPermissionDocumentTypeName = g = this.getMaintenanceDocumentDictionaryService().getDocumentTypeName(GenericPermissionBo.class);
                }
            }
        }
        return g;
    }

    @Override
    protected List<? extends BusinessObject> getMemberSearchResults(Map<String, String> searchCriteria, boolean unbounded) {
        Map<String, String> permissionSearchCriteria = this.buildSearchCriteria(searchCriteria);
        Map<String, String> roleSearchCriteria = this.buildRoleSearchCriteria(searchCriteria);
        boolean permissionCriteriaEmpty = permissionSearchCriteria == null || permissionSearchCriteria.isEmpty();
        boolean roleCriteriaEmpty = roleSearchCriteria == null || roleSearchCriteria.isEmpty();
        Object permissionSearchResultsCopy = new CollectionIncomplete(new ArrayList(), new Long(0L));
        if (!permissionCriteriaEmpty && !roleCriteriaEmpty) {
            permissionSearchResultsCopy = this.getCombinedSearchResults(permissionSearchCriteria, roleSearchCriteria, unbounded);
        } else if (permissionCriteriaEmpty && !roleCriteriaEmpty) {
            permissionSearchResultsCopy = this.getPermissionsWithRoleSearchCriteria(roleSearchCriteria, unbounded);
        } else if (!permissionCriteriaEmpty && roleCriteriaEmpty) {
            permissionSearchResultsCopy = this.getPermissionsWithPermissionSearchCriteria(permissionSearchCriteria, unbounded);
        } else if (permissionCriteriaEmpty && roleCriteriaEmpty) {
            return this.getAllPermissions(unbounded);
        }
        return permissionSearchResultsCopy;
    }

    private List<UberPermissionBo> getAllPermissions(boolean unbounded) {
        List<UberPermissionBo> permissions = this.searchPermissions(new HashMap<String, String>(), unbounded);
        for (UberPermissionBo permission : permissions) {
            this.populateAssignedToRoles(permission);
        }
        return permissions;
    }

    private List<UberPermissionBo> getCombinedSearchResults(Map<String, String> permissionSearchCriteria, Map<String, String> roleSearchCriteria, boolean unbounded) {
        List<UberPermissionBo> permissionSearchResults = this.searchPermissions(permissionSearchCriteria, unbounded);
        List<RoleBo> roleSearchResults = this.searchRoles(roleSearchCriteria, unbounded);
        List<UberPermissionBo> permissionsForRoleSearchResults = this.getPermissionsForRoleSearchResults(roleSearchResults, unbounded);
        CollectionIncomplete matchedPermissions = new CollectionIncomplete(new ArrayList(), this.getActualSizeIfTruncated(permissionsForRoleSearchResults));
        if (permissionSearchResults != null && !permissionSearchResults.isEmpty() && permissionsForRoleSearchResults != null && !permissionsForRoleSearchResults.isEmpty()) {
            for (UberPermissionBo permission : permissionSearchResults) {
                for (UberPermissionBo permissionFromRoleSearch : permissionsForRoleSearchResults) {
                    if (!permissionFromRoleSearch.getId().equals(permission.getId())) continue;
                    matchedPermissions.add(permissionFromRoleSearch);
                }
            }
        }
        return matchedPermissions;
    }

    private List<UberPermissionBo> searchPermissions(Map<String, String> permissionSearchCriteria, boolean unbounded) {
        return this.getPermissionsSearchResultsCopy(new ArrayList<PermissionBo>(this.getLookupService().findCollectionBySearchHelper(PermissionBo.class, permissionSearchCriteria, unbounded)));
    }

    private List<UberPermissionBo> getPermissionsWithRoleSearchCriteria(Map<String, String> roleSearchCriteria, boolean unbounded) {
        return this.getPermissionsForRoleSearchResults(this.searchRoles(roleSearchCriteria, unbounded), unbounded);
    }

    private List<UberPermissionBo> getPermissionsForRoleSearchResults(List<RoleBo> roleSearchResults, boolean unbounded) {
        Long actualSizeIfTruncated = this.getActualSizeIfTruncated(roleSearchResults);
        List<UberPermissionBo> permissions = new ArrayList<UberPermissionBo>();
        ArrayList<String> collectedPermissionIds = new ArrayList<String>();
        for (RoleBo roleImpl : roleSearchResults) {
            HashMap<String, String> permissionCriteria = new HashMap<String, String>();
            permissionCriteria.put("rolePermissions.roleId", roleImpl.getId());
            List<UberPermissionBo> tempPermissions = this.searchPermissions(permissionCriteria, unbounded);
            actualSizeIfTruncated = actualSizeIfTruncated + this.getActualSizeIfTruncated(tempPermissions);
            for (UberPermissionBo permission : tempPermissions) {
                if (collectedPermissionIds.contains(permission.getId())) continue;
                this.populateAssignedToRoles(permission);
                collectedPermissionIds.add(permission.getId());
                permissions.add(permission);
            }
            List parentRoleIds = KimApiServiceLocator.getRoleService().getMemberParentRoleIds(MemberType.ROLE.getCode(), roleImpl.getId());
            for (String parentRoleId : parentRoleIds) {
                HashMap<String, String> roleSearchCriteria = new HashMap<String, String>();
                roleSearchCriteria.put("id", parentRoleId);
                permissions = this.mergePermissionLists(permissions, this.getPermissionsWithRoleSearchCriteria(roleSearchCriteria, unbounded));
            }
        }
        return new CollectionIncomplete(permissions, actualSizeIfTruncated);
    }

    private void populateAssignedToRoles(UberPermissionBo permission) {
        for (RolePermissionBo rolePermission : permission.getRolePermissions()) {
            RoleBo roleBo;
            if (!rolePermission.isActive() || (roleBo = (RoleBo)KradDataServiceLocator.getDataObjectService().find(RoleBo.class, (Object)rolePermission.getRoleId())) == null) continue;
            permission.getAssignedToRoles().add(roleBo);
        }
    }

    private List<UberPermissionBo> getPermissionsWithPermissionSearchCriteria(Map<String, String> permissionSearchCriteria, boolean unbounded) {
        String detailCriteriaStr = permissionSearchCriteria.remove("detailCriteria");
        Map<String, String> detailCriteria = this.parseDetailCriteria(detailCriteriaStr);
        List<UberPermissionBo> permissions = this.searchPermissions(permissionSearchCriteria, unbounded);
        CollectionIncomplete filteredPermissions = new CollectionIncomplete(new ArrayList(), this.getActualSizeIfTruncated(permissions));
        for (UberPermissionBo perm : permissions) {
            if (detailCriteria.isEmpty()) {
                filteredPermissions.add(perm);
                this.populateAssignedToRoles(perm);
                continue;
            }
            if (!this.isMapSubset(new HashMap<String, String>(perm.getDetails()), detailCriteria)) continue;
            filteredPermissions.add(perm);
            this.populateAssignedToRoles(perm);
        }
        return filteredPermissions;
    }

    private List<UberPermissionBo> getPermissionsSearchResultsCopy(List<PermissionBo> permissionSearchResults) {
        CollectionIncomplete permissionSearchResultsCopy = new CollectionIncomplete(new ArrayList(), this.getActualSizeIfTruncated(permissionSearchResults));
        for (PermissionBo permissionBo : permissionSearchResults) {
            UberPermissionBo permissionCopy = new UberPermissionBo();
            try {
                PropertyUtils.copyProperties((Object)permissionCopy, (Object)permissionBo);
                permissionCopy.setTemplate(permissionBo.getTemplate());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("unable to copy properties", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("unable to copy properties", e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("unable to copy properties", e);
            }
            permissionSearchResultsCopy.add(permissionCopy);
        }
        return permissionSearchResultsCopy;
    }

    public synchronized LookupService getLookupService() {
        if (this.lookupService == null) {
            this.lookupService = KRADServiceLocatorWeb.getLookupService();
        }
        return this.lookupService;
    }

    public synchronized RoleService getRoleService() {
        if (this.roleService == null) {
            this.roleService = KimApiServiceLocator.getRoleService();
        }
        return this.roleService;
    }

    private List<UberPermissionBo> mergePermissionLists(List<UberPermissionBo> perm1, List<UberPermissionBo> perm2) {
        ArrayList<UberPermissionBo> returnList = new ArrayList<UberPermissionBo>(perm1);
        ArrayList<String> permissionIds = new ArrayList<String>(perm1.size());
        for (UberPermissionBo perm : returnList) {
            permissionIds.add(perm.getId());
        }
        for (int i = 0; i < perm2.size(); ++i) {
            if (permissionIds.contains(perm2.get(i).getId())) continue;
            returnList.add(perm2.get(i));
        }
        return returnList;
    }
}

