/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kcb.service.impl;

import java.util.Collection;
import java.util.List;

import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kcb.bo.Message;
import org.kuali.rice.kcb.service.MessageService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;

import static org.kuali.rice.core.api.criteria.PredicateFactory.equal;

/**
 * MessageService implementation 
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class MessageServiceImpl implements MessageService {

    private DataObjectService dataObjectService;
    /**
     * @see org.kuali.rice.kcb.service.MessageService#deleteMessage(org.kuali.rice.kcb.bo.Message)
     */
    @Override
    public void deleteMessage(Message message) {
        dataObjectService.delete(message);
    }

    /**
     * @see org.kuali.rice.kcb.service.MessageService#getMessage(java.lang.Long)
     */
    @Override
    public Message getMessage(Long id) {
        return dataObjectService.find(Message.class, id);
    }

    /**
     * @see org.kuali.rice.kcb.service.MessageService#getAllMessages()
     */
    @Override
    public Collection<Message> getAllMessages() {
        return dataObjectService.findMatching(Message.class, QueryByCriteria.Builder.create().build()).getResults();
    }

    /**
     * @see org.kuali.rice.kcb.service.MessageService#saveMessage(org.kuali.rice.kcb.bo.Message)
     */
    @Override
    public Message saveMessage(Message message) {
        return dataObjectService.save(message);
    }

    /**
     * @see org.kuali.rice.kcb.service.MessageService#getMessageByOriginId(java.lang.String)
     */
    @Override
    public Message getMessageByOriginId(String originId) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(equal(Message.ORIGINID_FIELD, originId));
        List<Message> messages = dataObjectService.findMatching(Message.class, criteria.build()).getResults();

        if (messages.isEmpty()) {
            return null;
        }

        return messages.get(0);
    }

    /**
     * Sets the data object service.
     * @param dataObjectService persits data to the datasource.
     */
    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}
