/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ken.util;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.kuali.rice.ken.bo.NotificationContentTypeBo;
import org.kuali.rice.ken.service.NotificationContentTypeService;

/**
 * Utility base class for Entity and LSResource Resolvers that should resolve
 * arguments to XSDs defined for NotificationContentTypes
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ContentTypeResourceResolver {
    protected static final String CONTENT_TYPE_PREFIX = "resource:notification/ContentType";

    protected final Logger LOG = LogManager.getLogger(getClass());
    
    private NotificationContentTypeService notificationContentTypeService;

    public ContentTypeResourceResolver(NotificationContentTypeService notificationContentTypeService) {
	this.notificationContentTypeService = notificationContentTypeService;
    }

    /**
     * This method resolves the NotificationContentType by id.
     */
    public NotificationContentTypeBo resolveContentType(String id) {
	if (!id.startsWith(CONTENT_TYPE_PREFIX)) return null;
        String contentType = id.substring(CONTENT_TYPE_PREFIX.length());
        NotificationContentTypeBo notificationContentType = notificationContentTypeService.getNotificationContentType(contentType);
        if (contentType == null) {
            LOG.warn("Content type '" + contentType + "' not found in notification database");
            return null;
        }

        LOG.info("Resolved '" + id + "' to notification content type: " + notificationContentType);
        return notificationContentType;
    }
}
