/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ken.util;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/**
 * A simple SAX ErrorHandler implementation that logs to a global logger for this
 * class, or the one provided.
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class SimpleErrorHandler implements ErrorHandler {
    private static final Logger LOG = LogManager.getLogger(SimpleErrorHandler.class);

    private final Logger log;


    public SimpleErrorHandler() {
        this.log = LOG;
    }

    public SimpleErrorHandler(Logger log) {
        this.log = log;
    }

    @Override
    public void warning(SAXParseException se) {
        log.warn("Warning parsing xml doc " + se.getSystemId(), se);
    }

    @Override
    public void error(SAXParseException se) throws SAXException {
        log.error("Error parsing xml doc " + se.getSystemId(), se);
        throw se;
    }

    @Override
    public void fatalError(SAXParseException se) throws SAXException {
        log.error("Fatal error parsing xml doc " + se.getSystemId(), se);
        throw se;
    }
}
