/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.actiontaken.service;

import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;


/**
 * Responsible for the data access for {@link ActionTakenValue} objects.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface ActionTakenService {

    ActionTakenValue findByActionTakenId(String actionTakenId);

    ActionTakenValue saveActionTaken(ActionTakenValue actionTaken);

    ActionTakenValue getPreviousAction(ActionRequestValue actionRequest);

    ActionTakenValue getPreviousAction(ActionRequestValue actionRequest, List<ActionTakenValue> simulatedActionsTaken);

    Collection<ActionTakenValue> findByDocumentId(String documentId);

    List<ActionTakenValue> findByDocumentIdPrincipalId(String documentId, String workflowId);

    void delete(ActionTakenValue actionTaken);

    List<ActionTakenValue> findByDocumentIdIgnoreCurrentInd(String documentId);

    boolean hasUserTakenAction(String principalId, String documentId);

    Timestamp getLastApprovedDate(String documentId);

}
