/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.impl.document.search;

import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.document.search.DocumentSearchResults;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;


/**
 * Handles various functions related to generation and processing of document searches.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface DocumentSearchGenerator {

    List<RemotableAttributeError> validateSearchableAttributes(DocumentSearchCriteria.Builder criteria);

    String generateSearchSql(DocumentSearchCriteria criteria, List<RemotableAttributeField> searchFields);

    DocumentSearchResults.Builder processResultSet(DocumentSearchCriteria criteria, boolean criteriaModified, Statement searchAttributeStatement, ResultSet resultSet, int actualMaxResults, int fetchLimit) throws SQLException;
    
    DocumentSearchCriteria clearSearch(DocumentSearchCriteria criteria);

}
