/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.rule.bo;

import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kew.api.action.ActionRequestPolicy;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * A values finder for returning KEW approve policy codes.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ApprovePolicyValuesFinder extends KeyValuesBase {

	private static final List<KeyValue> REQUEST_POLICIES;
	static {
		final List<KeyValue> temp = new ArrayList<KeyValue>();
		for (ActionRequestPolicy policy : ActionRequestPolicy.values()) {
			temp.add(new ConcreteKeyValue(policy.getCode(), policy.getLabel()));
		}
		REQUEST_POLICIES = Collections.unmodifiableList(temp);
	}
	
	@Override
	public List<KeyValue> getKeyValues() {
		return REQUEST_POLICIES;
	}

}
