/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.util;

import java.util.Formatter;

/**
 * Records and logs performance information about an elapsed time period.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class PerformanceLogger {

    private static final org.apache.logging.log4j.Logger LOG =
        org.apache.logging.log4j.LogManager.getLogger(PerformanceLogger.class);
    private long startTime;
    private String documentId;
    
    public PerformanceLogger() {
        recordStartTime();
    }
    
    public PerformanceLogger(String documentId) {
        this();
        this.documentId = documentId;
    }
    
    private void recordStartTime() {
        this.startTime = System.currentTimeMillis();
    }
    
    public void log(String message) {
        log(message, false);
    }

    public void log(String message, boolean terminalPoint) {
    	if ( LOG.isInfoEnabled() ) {
	        long endTime = System.currentTimeMillis();
	        long totalTime = endTime - startTime;
            try (Formatter formatter = new Formatter()) {
                String logMessage = formatter.format("Time: %7dms, ", totalTime).toString();
                if (documentId != null) {
                    logMessage+="docId="+documentId+", ";
                }
                logMessage += message;
                if (terminalPoint) {
                    logMessage += "\n";
                }
                LOG.info(logMessage);
            }
    	}
    }

    public void debug(String message) {
        this.debug(message, false);
    }

    public void debug(String message, boolean terminalPoint) {
        if ( LOG.isDebugEnabled() ) {
            long endTime = System.currentTimeMillis();
            long totalTime = endTime - startTime;
            try (Formatter formatter = new Formatter()) {
                String logMessage = formatter.format("Time: %7dms, ", totalTime).toString();
                if (documentId != null) {
                    logMessage+="docId="+documentId+", ";
                }
                logMessage += message;
                if (terminalPoint) {
                    logMessage += "\n";
                }
                LOG.debug(logMessage);
            }
        }
    }
}
