/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.rule.event.ui;

import org.kuali.rice.kim.bo.ui.KimDocumentRolePermission;
import org.kuali.rice.kim.document.IdentityManagementRoleDocument;
import org.kuali.rice.kim.rule.ui.AddPermissionRule;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.BusinessRule;
import org.kuali.rice.krad.rules.rule.event.DocumentEventBase;

public class AddPermissionEvent extends DocumentEventBase {
	private KimDocumentRolePermission permission;

	public AddPermissionEvent(String errorPathPrefix, IdentityManagementRoleDocument document) {
        super("adding Permission document " + getDocumentId(document), errorPathPrefix, document);
    }

    public AddPermissionEvent(String errorPathPrefix, Document document, KimDocumentRolePermission permission) {
        this(errorPathPrefix, (IdentityManagementRoleDocument) document);
        this.permission = KradDataServiceLocator.getDataObjectService().copyInstance(permission);
    }

    @Override
    public Class<? extends BusinessRule> getRuleInterfaceClass() {
        return AddPermissionRule.class;
    }

    @Override
    public boolean invokeRuleMethod(BusinessRule rule) {
        return ((AddPermissionRule) rule).processAddPermission(this);
    }

	/**
	 * @return the permission
	 */
	public KimDocumentRolePermission getPermission() {
		return this.permission;
	}

	/**
	 * @param permission the permission to set
	 */
	public void setPermission(KimDocumentRolePermission permission) {
		this.permission = permission;
	}

}
