/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.routeheader.service.impl;

import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionrequest.KimGroupRecipient;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.actions.AcknowledgeAction;
import org.kuali.rice.kew.actions.AdHocAction;
import org.kuali.rice.kew.actions.ApproveAction;
import org.kuali.rice.kew.actions.BlanketApproveAction;
import org.kuali.rice.kew.actions.CancelAction;
import org.kuali.rice.kew.actions.ClearFYIAction;
import org.kuali.rice.kew.actions.CompleteAction;
import org.kuali.rice.kew.actions.DisapproveAction;
import org.kuali.rice.kew.actions.LogDocumentActionAction;
import org.kuali.rice.kew.actions.MoveDocumentAction;
import org.kuali.rice.kew.actions.RecallAction;
import org.kuali.rice.kew.actions.ReleaseWorkgroupAuthority;
import org.kuali.rice.kew.actions.ReturnToPreviousNodeAction;
import org.kuali.rice.kew.actions.RevokeAdHocAction;
import org.kuali.rice.kew.actions.RouteDocumentAction;
import org.kuali.rice.kew.actions.SaveActionEvent;
import org.kuali.rice.kew.actions.SuperUserActionRequestApproveEvent;
import org.kuali.rice.kew.actions.SuperUserApproveEvent;
import org.kuali.rice.kew.actions.SuperUserCancelEvent;
import org.kuali.rice.kew.actions.SuperUserDisapproveEvent;
import org.kuali.rice.kew.actions.SuperUserNodeApproveEvent;
import org.kuali.rice.kew.actions.SuperUserReturnToPreviousNodeAction;
import org.kuali.rice.kew.actions.TakeWorkgroupAuthority;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.action.ActionInvocation;
import org.kuali.rice.kew.api.action.ActionInvocationQueue;
import org.kuali.rice.kew.api.action.AdHocRevoke;
import org.kuali.rice.kew.api.action.MovePoint;
import org.kuali.rice.kew.api.doctype.IllegalDocumentTypeException;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeIndexingQueue;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.engine.CompatUtils;
import org.kuali.rice.kew.engine.OrchestrationConfig;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.framework.postprocessor.ActionTakenEvent;
import org.kuali.rice.kew.framework.postprocessor.PostProcessor;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.service.WorkflowDocumentService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;

public class WorkflowDocumentServiceImpl
implements WorkflowDocumentService {
    private static final Logger LOG = LogManager.getLogger(WorkflowDocumentServiceImpl.class);

    private void init(DocumentRouteHeaderValue routeHeader) {
        KEWServiceLocator.getRouteHeaderService().lockRouteHeader(routeHeader.getDocumentId());
        KEWServiceLocator.getRouteHeaderService().saveRouteHeader(routeHeader);
    }

    public DocumentRouteHeaderValue finish(DocumentRouteHeaderValue routeHeader) {
        if (RouteContext.getCurrentRouteContext().getDocument() == null) {
            return KEWServiceLocator.getRouteHeaderService().getRouteHeader(routeHeader.getDocumentId(), true);
        }
        return routeHeader;
    }

    @Override
    public DocumentRouteHeaderValue acknowledgeDocument(String principalId, DocumentRouteHeaderValue routeHeader, String annotation) throws InvalidActionTakenException {
        Principal principal = this.loadPrincipal(principalId);
        AcknowledgeAction action = new AcknowledgeAction(routeHeader, (PrincipalContract)principal, annotation);
        action.performAction();
        return this.finish(routeHeader);
    }

    @Override
    public DocumentRouteHeaderValue releaseGroupAuthority(String principalId, DocumentRouteHeaderValue routeHeader, String groupId, String annotation) throws InvalidActionTakenException {
        Principal principal = this.loadPrincipal(principalId);
        ReleaseWorkgroupAuthority action = new ReleaseWorkgroupAuthority(routeHeader, (PrincipalContract)principal, annotation, groupId);
        action.performAction();
        return this.finish(routeHeader);
    }

    @Override
    public DocumentRouteHeaderValue takeGroupAuthority(String principalId, DocumentRouteHeaderValue routeHeader, String groupId, String annotation) throws InvalidActionTakenException {
        Principal principal = this.loadPrincipal(principalId);
        TakeWorkgroupAuthority action = new TakeWorkgroupAuthority(routeHeader, (PrincipalContract)principal, annotation, groupId);
        action.performAction();
        return this.finish(routeHeader);
    }

    @Override
    public DocumentRouteHeaderValue approveDocument(String principalId, DocumentRouteHeaderValue routeHeader, String annotation) throws InvalidActionTakenException {
        Principal principal = this.loadPrincipal(principalId);
        ApproveAction action = new ApproveAction(routeHeader, (PrincipalContract)principal, annotation);
        action.performAction();
        return this.finish(routeHeader);
    }

    @Override
    public DocumentRouteHeaderValue placeInExceptionRouting(String principalId, DocumentRouteHeaderValue routeHeader, String annotation) throws InvalidActionTakenException {
        try {
            KEWServiceLocator.getExceptionRoutingService().placeInExceptionRouting(annotation, null, routeHeader.getDocumentId());
        }
        catch (Exception e) {
            throw new RiceRuntimeException("Failed to place the document into exception routing!", (Throwable)e);
        }
        return this.finish(routeHeader);
    }

    @Override
    public DocumentRouteHeaderValue adHocRouteDocumentToPrincipal(String principalId, DocumentRouteHeaderValue document, String actionRequested, String nodeName, Integer priority, String annotation, String targetPrincipalId, String responsibilityDesc, Boolean forceAction, String requestLabel) throws WorkflowException {
        Principal principal = this.loadPrincipal(principalId);
        Recipient recipient = KEWServiceLocator.getIdentityHelperService().getPrincipalRecipient(targetPrincipalId);
        AdHocAction action = new AdHocAction(document, (PrincipalContract)principal, annotation, actionRequested, nodeName, priority, recipient, responsibilityDesc, forceAction, requestLabel);
        action.performAction();
        return this.finish(document);
    }

    @Override
    public DocumentRouteHeaderValue adHocRouteDocumentToGroup(String principalId, DocumentRouteHeaderValue document, String actionRequested, String nodeName, Integer priority, String annotation, String groupId, String responsibilityDesc, Boolean forceAction, String requestLabel) throws WorkflowException {
        Principal principal = this.loadPrincipal(principalId);
        KimGroupRecipient recipient = new KimGroupRecipient(KimApiServiceLocator.getGroupService().getGroup(groupId));
        AdHocAction action = new AdHocAction(document, (PrincipalContract)principal, annotation, actionRequested, nodeName, priority, recipient, responsibilityDesc, forceAction, requestLabel);
        action.performAction();
        return this.finish(document);
    }

    @Override
    public DocumentRouteHeaderValue blanketApproval(String principalId, DocumentRouteHeaderValue routeHeader, String annotation, Integer routeLevel) throws InvalidActionTakenException {
        RouteNode node;
        RouteNode routeNode = node = routeLevel == null ? null : CompatUtils.getNodeForLevel(routeHeader.getDocumentType(), routeLevel);
        if (node == null && routeLevel != null) {
            throw new InvalidActionTakenException("Could not locate node for route level " + routeLevel);
        }
        HashSet<String> nodeNames = new HashSet();
        if (node != null) {
            nodeNames = Collections.singleton(node.getRouteNodeName());
        }
        Principal principal = this.loadPrincipal(principalId);
        BlanketApproveAction action = new BlanketApproveAction(routeHeader, (PrincipalContract)principal, annotation, nodeNames);
        action.performAction();
        return this.finish(routeHeader);
    }

    @Override
    public DocumentRouteHeaderValue blanketApproval(String principalId, DocumentRouteHeaderValue routeHeader, String annotation, Set nodeNames) throws InvalidActionTakenException {
        Principal principal = this.loadPrincipal(principalId);
        BlanketApproveAction action = new BlanketApproveAction(routeHeader, (PrincipalContract)principal, annotation, nodeNames);
        action.recordAction();
        return this.finish(routeHeader);
    }

    @Override
    public DocumentRouteHeaderValue cancelDocument(String principalId, DocumentRouteHeaderValue routeHeader, String annotation) throws InvalidActionTakenException {
        Principal principal = this.loadPrincipal(principalId);
        CancelAction action = new CancelAction(routeHeader, (PrincipalContract)principal, annotation);
        action.recordAction();
        this.indexForSearchAfterActionIfNecessary(routeHeader);
        return this.finish(routeHeader);
    }

    @Override
    public DocumentRouteHeaderValue recallDocument(String principalId, DocumentRouteHeaderValue routeHeader, String annotation, boolean cancel) throws InvalidActionTakenException {
        if (!routeHeader.isFinal() && !routeHeader.isProcessed()) {
            Principal principal = this.loadPrincipal(principalId);
            RecallAction action = new RecallAction(routeHeader, (PrincipalContract)principal, annotation, cancel);
            action.performAction();
            this.indexForSearchAfterActionIfNecessary(routeHeader);
        } else {
            GlobalVariables.getMessageMap().putError("document", "message.recall.not.supported", new String[0]);
        }
        return this.finish(routeHeader);
    }

    protected void indexForSearchAfterActionIfNecessary(DocumentRouteHeaderValue routeHeader) {
        RouteContext routeContext = RouteContext.getCurrentRouteContext();
        if (routeHeader.getDocumentType().hasSearchableAttributes() && routeContext.isSearchIndexingRequestedForContext()) {
            DocumentAttributeIndexingQueue queue = KewApiServiceLocator.getDocumentAttributeIndexingQueue((String)routeHeader.getDocumentType().getApplicationId());
            queue.indexDocument(routeHeader.getDocumentId());
        }
    }

    @Override
    public DocumentRouteHeaderValue clearFYIDocument(String principalId, DocumentRouteHeaderValue routeHeader, String annotation) throws InvalidActionTakenException {
        Principal principal = this.loadPrincipal(principalId);
        ClearFYIAction action = new ClearFYIAction(routeHeader, (PrincipalContract)principal, annotation);
        action.recordAction();
        return this.finish(routeHeader);
    }

    @Override
    public DocumentRouteHeaderValue completeDocument(String principalId, DocumentRouteHeaderValue routeHeader, String annotation) throws InvalidActionTakenException {
        Principal principal = this.loadPrincipal(principalId);
        CompleteAction action = new CompleteAction(routeHeader, (PrincipalContract)principal, annotation);
        action.performAction();
        return this.finish(routeHeader);
    }

    @Override
    public DocumentRouteHeaderValue createDocument(String principalId, DocumentRouteHeaderValue routeHeader) throws WorkflowException {
        if (routeHeader.getDocumentId() != null) {
            throw new InvalidActionTakenException("Document already has a Document id");
        }
        Principal principal = this.loadPrincipal(principalId);
        boolean canInitiate = KEWServiceLocator.getDocumentTypePermissionService().canInitiate(principalId, routeHeader.getDocumentType());
        if (!canInitiate) {
            throw new InvalidActionTakenException("Principal with name '" + principal.getPrincipalName() + "' is not authorized to initiate documents of type '" + routeHeader.getDocumentType().getName());
        }
        if (!routeHeader.getDocumentType().isDocTypeActive()) {
            throw new IllegalDocumentTypeException("Document type '" + routeHeader.getDocumentType().getName() + "' is inactive");
        }
        routeHeader.setInitiatorWorkflowId(principalId);
        if (routeHeader.getDocRouteStatus() == null) {
            routeHeader.setDocRouteStatus("I");
        }
        if (routeHeader.getDocRouteLevel() == null) {
            routeHeader.setDocRouteLevel(0);
        }
        if (routeHeader.getCreateDate() == null) {
            routeHeader.setCreateDate(new Timestamp(new Date().getTime()));
        }
        if (routeHeader.getDocVersion() == null) {
            routeHeader.setDocVersion(1);
        }
        if (routeHeader.getDocContent() == null) {
            routeHeader.setDocContent("<documentContent/>");
        }
        routeHeader.setDateModified(new Timestamp(new Date().getTime()));
        routeHeader = KEWServiceLocator.getRouteHeaderService().saveRouteHeader(routeHeader);
        OrchestrationConfig config = new OrchestrationConfig(OrchestrationConfig.EngineCapability.STANDARD);
        KEWServiceLocator.getWorkflowEngineFactory().newEngine(config).initializeDocument(routeHeader);
        routeHeader = KEWServiceLocator.getRouteHeaderService().saveRouteHeader(routeHeader);
        return routeHeader;
    }

    @Override
    public DocumentRouteHeaderValue disapproveDocument(String principalId, DocumentRouteHeaderValue routeHeader, String annotation) throws InvalidActionTakenException {
        Principal principal = this.loadPrincipal(principalId);
        DisapproveAction action = new DisapproveAction(routeHeader, (PrincipalContract)principal, annotation);
        action.recordAction();
        this.indexForSearchAfterActionIfNecessary(routeHeader);
        return this.finish(routeHeader);
    }

    @Override
    public DocumentRouteHeaderValue returnDocumentToPreviousRouteLevel(String principalId, DocumentRouteHeaderValue routeHeader, Integer destRouteLevel, String annotation) throws InvalidActionTakenException {
        DocumentRouteHeaderValue result = null;
        if (destRouteLevel != null) {
            RouteNode node = CompatUtils.getNodeForLevel(routeHeader.getDocumentType(), destRouteLevel);
            if (node == null) {
                throw new InvalidActionTakenException("Could not locate node for route level " + destRouteLevel);
            }
            Principal principal = this.loadPrincipal(principalId);
            ReturnToPreviousNodeAction action = new ReturnToPreviousNodeAction(routeHeader, (PrincipalContract)principal, annotation, node.getRouteNodeName(), true);
            action.performAction();
            result = this.finish(routeHeader);
        }
        return result;
    }

    @Override
    public DocumentRouteHeaderValue returnDocumentToPreviousNode(String principalId, DocumentRouteHeaderValue routeHeader, String destinationNodeName, String annotation) throws InvalidActionTakenException {
        Principal principal = this.loadPrincipal(principalId);
        ReturnToPreviousNodeAction action = new ReturnToPreviousNodeAction(routeHeader, (PrincipalContract)principal, annotation, destinationNodeName, true);
        action.performAction();
        return this.finish(routeHeader);
    }

    @Override
    public DocumentRouteHeaderValue routeDocument(String principalId, DocumentRouteHeaderValue routeHeader, String annotation) throws WorkflowException, InvalidActionTakenException {
        Principal principal = this.loadPrincipal(principalId);
        RouteDocumentAction actionEvent = new RouteDocumentAction(routeHeader, (PrincipalContract)principal, annotation);
        actionEvent.performAction();
        LOG.info("routeDocument: " + String.valueOf(routeHeader));
        return this.finish(routeHeader);
    }

    @Override
    public DocumentRouteHeaderValue saveRoutingData(String principalId, DocumentRouteHeaderValue routeHeader) {
        KEWServiceLocator.getRouteHeaderService().saveRouteHeader(routeHeader);
        ActionTakenValue val = new ActionTakenValue();
        val.setActionTaken("S");
        val.setDocumentId(routeHeader.getDocumentId());
        val.setPrincipalId(principalId);
        PostProcessor postProcessor = routeHeader.getDocumentType().getPostProcessor();
        try {
            postProcessor.doActionTaken(new ActionTakenEvent(routeHeader.getDocumentId(), routeHeader.getAppDocId(), ActionTakenValue.to(val)));
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new WorkflowRuntimeException((Throwable)e);
        }
        RouteContext routeContext = RouteContext.getCurrentRouteContext();
        if (routeHeader.getDocumentType().hasSearchableAttributes() && !routeContext.isSearchIndexingRequestedForContext()) {
            routeContext.requestSearchIndexingForContext();
            DocumentAttributeIndexingQueue queue = KewApiServiceLocator.getDocumentAttributeIndexingQueue((String)routeHeader.getDocumentType().getApplicationId());
            queue.indexDocument(routeHeader.getDocumentId());
        }
        return this.finish(routeHeader);
    }

    @Override
    public DocumentRouteHeaderValue saveDocument(String principalId, DocumentRouteHeaderValue routeHeader, String annotation) throws InvalidActionTakenException {
        Principal principal = this.loadPrincipal(principalId);
        SaveActionEvent action = new SaveActionEvent(routeHeader, (PrincipalContract)principal, annotation);
        action.performAction();
        return this.finish(routeHeader);
    }

    @Override
    public void deleteDocument(String principalId, DocumentRouteHeaderValue routeHeader) throws WorkflowException {
        if (routeHeader.getDocumentId() == null) {
            LOG.debug("Null Document id passed.");
            throw new WorkflowException("Document id must not be null.");
        }
        KEWServiceLocator.getRouteHeaderService().deleteRouteHeader(routeHeader);
    }

    @Override
    public void logDocumentAction(String principalId, DocumentRouteHeaderValue routeHeader, String annotation) throws InvalidActionTakenException {
        Principal principal = this.loadPrincipal(principalId);
        LogDocumentActionAction action = new LogDocumentActionAction(routeHeader, (PrincipalContract)principal, annotation);
        action.recordAction();
    }

    @Override
    public DocumentRouteHeaderValue moveDocument(String principalId, DocumentRouteHeaderValue routeHeader, MovePoint movePoint, String annotation) throws InvalidActionTakenException {
        Principal principal = this.loadPrincipal(principalId);
        MoveDocumentAction action = new MoveDocumentAction(routeHeader, (PrincipalContract)principal, annotation, movePoint);
        action.performAction();
        return this.finish(routeHeader);
    }

    @Override
    public DocumentRouteHeaderValue superUserActionRequestApproveAction(String principalId, DocumentRouteHeaderValue routeHeader, String actionRequestId, String annotation, boolean runPostProcessor) throws InvalidActionTakenException {
        this.init(routeHeader);
        Principal principal = this.loadPrincipal(principalId);
        SuperUserActionRequestApproveEvent suActionRequestApprove = new SuperUserActionRequestApproveEvent(routeHeader, (PrincipalContract)principal, actionRequestId, annotation, runPostProcessor);
        suActionRequestApprove.recordAction();
        RouteContext.getCurrentRouteContext().requestSearchIndexingForContext();
        this.indexForSearchAfterActionIfNecessary(routeHeader);
        return this.finish(routeHeader);
    }

    @Override
    public DocumentRouteHeaderValue superUserActionRequestApproveAction(String principalId, String documentId, String actionRequestId, String annotation, boolean runPostProcessor) throws InvalidActionTakenException {
        return this.superUserActionRequestApproveAction(principalId, KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId), actionRequestId, annotation, runPostProcessor);
    }

    @Override
    public DocumentRouteHeaderValue superUserApprove(String principalId, DocumentRouteHeaderValue routeHeader, String annotation, boolean runPostProcessor) throws InvalidActionTakenException {
        this.init(routeHeader);
        Principal principal = this.loadPrincipal(principalId);
        new SuperUserApproveEvent(routeHeader, (PrincipalContract)principal, annotation, runPostProcessor).recordAction();
        RouteContext.getCurrentRouteContext().requestSearchIndexingForContext();
        this.indexForSearchAfterActionIfNecessary(routeHeader);
        return this.finish(routeHeader);
    }

    @Override
    public DocumentRouteHeaderValue superUserCancelAction(String principalId, DocumentRouteHeaderValue routeHeader, String annotation, boolean runPostProcessor) throws InvalidActionTakenException {
        this.init(routeHeader);
        Principal principal = this.loadPrincipal(principalId);
        new SuperUserCancelEvent(routeHeader, (PrincipalContract)principal, annotation, runPostProcessor).recordAction();
        RouteContext.getCurrentRouteContext().requestSearchIndexingForContext();
        this.indexForSearchAfterActionIfNecessary(routeHeader);
        return this.finish(routeHeader);
    }

    @Override
    public DocumentRouteHeaderValue superUserDisapproveAction(String principalId, DocumentRouteHeaderValue routeHeader, String annotation, boolean runPostProcessor) throws InvalidActionTakenException {
        this.init(routeHeader);
        Principal principal = this.loadPrincipal(principalId);
        new SuperUserDisapproveEvent(routeHeader, (PrincipalContract)principal, annotation, runPostProcessor).recordAction();
        RouteContext.getCurrentRouteContext().requestSearchIndexingForContext();
        this.indexForSearchAfterActionIfNecessary(routeHeader);
        return this.finish(routeHeader);
    }

    @Override
    public DocumentRouteHeaderValue superUserNodeApproveAction(String principalId, DocumentRouteHeaderValue routeHeader, String nodeName, String annotation, boolean runPostProcessor) throws InvalidActionTakenException {
        this.init(routeHeader);
        Principal principal = this.loadPrincipal(principalId);
        new SuperUserNodeApproveEvent(routeHeader, (PrincipalContract)principal, annotation, runPostProcessor, nodeName).recordAction();
        this.indexForSearchAfterActionIfNecessary(routeHeader);
        return this.finish(routeHeader);
    }

    @Override
    public DocumentRouteHeaderValue superUserNodeApproveAction(String principalId, String documentId, String nodeName, String annotation, boolean runPostProcessor) throws InvalidActionTakenException {
        return this.superUserNodeApproveAction(principalId, KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId), nodeName, annotation, runPostProcessor);
    }

    @Override
    public DocumentRouteHeaderValue superUserReturnDocumentToPreviousNode(String principalId, String documentId, String nodeName, String annotation, boolean runPostProcessor) throws InvalidActionTakenException {
        return this.superUserReturnDocumentToPreviousNode(principalId, KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId), nodeName, annotation, runPostProcessor);
    }

    @Override
    public DocumentRouteHeaderValue superUserReturnDocumentToPreviousNode(String principalId, DocumentRouteHeaderValue routeHeader, String nodeName, String annotation, boolean runPostProcessor) throws InvalidActionTakenException {
        this.init(routeHeader);
        Principal principal = this.loadPrincipal(principalId);
        SuperUserReturnToPreviousNodeAction action = new SuperUserReturnToPreviousNodeAction(routeHeader, (PrincipalContract)principal, annotation, runPostProcessor, nodeName);
        action.recordAction();
        RouteContext.getCurrentRouteContext().requestSearchIndexingForContext();
        this.indexForSearchAfterActionIfNecessary(routeHeader);
        return this.finish(routeHeader);
    }

    @Override
    public void takeMassActions(String principalId, List<ActionInvocation> actionInvocations) {
        Principal principal = this.loadPrincipal(principalId);
        for (ActionInvocation invocation : actionInvocations) {
            ActionItem actionItem = KEWServiceLocator.getActionListService().findByActionItemId(invocation.getActionItemId());
            if (actionItem == null) {
                LOG.warn("Could not locate action item for the given action item id [" + invocation.getActionItemId() + "], not taking mass action on it.");
                continue;
            }
            KEWServiceLocator.getActionListService().deleteActionItem(actionItem, true);
            DocumentRouteHeaderValue document = KEWServiceLocator.getRouteHeaderService().getRouteHeader(actionItem.getDocumentId());
            String applicationId = document.getDocumentType().getApplicationId();
            ActionInvocationQueue actionInvocQueue = KewApiServiceLocator.getActionInvocationProcessorService((String)applicationId);
            actionInvocQueue.invokeAction(principalId, actionItem.getDocumentId(), invocation);
        }
    }

    @Override
    public DocumentRouteHeaderValue revokeAdHocRequests(String principalId, DocumentRouteHeaderValue document, AdHocRevoke revoke, String annotation) throws InvalidActionTakenException {
        Principal principal = this.loadPrincipal(principalId);
        RevokeAdHocAction action = new RevokeAdHocAction(document, (PrincipalContract)principal, revoke, annotation);
        action.performAction();
        return this.finish(document);
    }

    @Override
    public DocumentRouteHeaderValue revokeAdHocRequests(String principalId, DocumentRouteHeaderValue document, String actionRequestId, String annotation) throws InvalidActionTakenException {
        Principal principal = this.loadPrincipal(principalId);
        RevokeAdHocAction action = new RevokeAdHocAction(document, (PrincipalContract)principal, actionRequestId, annotation);
        action.performAction();
        return this.finish(document);
    }

    public Principal loadPrincipal(String principalId) {
        return KEWServiceLocator.getIdentityHelperService().getPrincipal(principalId);
    }
}

