/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kcb.api.message;

import java.io.Serializable;

import org.apache.commons.lang.builder.ReflectionToStringBuilder;


/**
 * Message value object for published API  
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class MessageDTO implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private String deliveryType;
    private String title;
    private String channel;
    private String producer;
    private String content;
    private String contentType;
    private String recipient;
    private String url;
    private String originId;

    public String getDeliveryType() {
        return this.deliveryType;
    }
    public void setDeliveryType(String deliveryType) {
        this.deliveryType = deliveryType;
    }
    public String getTitle() {
        return this.title;
    }
    public void setTitle(String title) {
        this.title = title;
    }
    public String getContent() {
        return this.content;
    }
    public void setContent(String content) {
        this.content = content;
    }
    public String getContentType() {
        return this.contentType;
    }
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
    public String getRecipient() {
        return this.recipient;
    }
    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }
    public String getChannel() {
        return this.channel;
    }
    public void setChannel(String channel) {
        this.channel = channel;
    }
    public String getProducer() {
        return this.producer;
    }
    public void setProducer(String producer) {
        this.producer = producer;
    }
    public String getUrl() {
        return this.url;
    }
    public void setUrl(String url) {
        this.url = url;
    }
    public String getOriginId() {
        return this.originId;
    }
    public void setOriginId(String originId) {
        this.originId = originId;
    }
    
    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
