/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ken.api.notification;

import org.joda.time.DateTime;
import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.ken.api.common.KenIdentifiable;

import java.util.List;

public interface NotificationContract extends KenIdentifiable, Versioned, GloballyUnique {

    /**
     * This is the namespace code for the Group.
     *
     * <p>
     * This is a namespace code assigned to a Group.  Together with name, it makes up another unique identifier for Group
     * </p>
     *
     * @return namespaceCode
     */
    DateTime getCreationDateTime();

    List<? extends NotificationRecipientContract> getRecipients();

    List<? extends NotificationSenderContract> getSenders();

    DateTime getAutoRemoveDateTime();

    NotificationChannelContract getChannel();

    String getContent();

    NotificationContentTypeContract getContentType();

    String getDeliveryType();

    NotificationPriorityContract getPriority();

    NotificationProducerContract getProducer();
    
    DateTime getSendDateTime();

    String getProcessingFlag();

    DateTime getLockedDate();

    String getTitle();

    String getContentMessage();

    /**
     * Gets the custom document type name
     *
     * <p>
     * If null, the system will use the default {@code KualiNotification} document type when routing the notification
     * </p>
     *
     * @return the custom document type name for this Notification, or null if undefined
     * @since 2.3.1
     */
    String getDocTypeName();
}
