/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.doctype;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kew.api.doctype.DocumentTypeAttributeContract;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.w3c.dom.Element;

@XmlRootElement(name="documentTypeAttribute")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="DocumentTypeAttributeType", propOrder={"id", "ruleAttribute", "documentTypeId", "orderIndex", "_futureElements"})
public final class DocumentTypeAttribute
extends AbstractDataTransferObject
implements DocumentTypeAttributeContract {
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="ruleAttribute", required=true)
    private final ExtensionDefinition ruleAttribute;
    @XmlElement(name="documentTypeId", required=true)
    private final String documentTypeId;
    @XmlElement(name="orderIndex", required=false)
    private final int orderIndex;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private DocumentTypeAttribute() {
        this.ruleAttribute = null;
        this.documentTypeId = null;
        this.orderIndex = 0;
        this.id = null;
    }

    private DocumentTypeAttribute(Builder builder) {
        this.ruleAttribute = builder.getRuleAttribute().build();
        this.documentTypeId = builder.getDocumentTypeId();
        this.orderIndex = builder.getOrderIndex();
        this.id = builder.getId();
    }

    @Override
    public ExtensionDefinition getRuleAttribute() {
        return this.ruleAttribute;
    }

    @Override
    public String getDocumentTypeId() {
        return this.documentTypeId;
    }

    @Override
    public int getOrderIndex() {
        return this.orderIndex;
    }

    public String getId() {
        return this.id;
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    DocumentTypeAttributeContract {
        private ExtensionDefinition.Builder ruleAttribute;
        private String documentTypeId;
        private int orderIndex;
        private String id;

        private Builder(String documentTypeId, ExtensionDefinition.Builder ruleAttribute) {
            this.setDocumentTypeId(documentTypeId);
            this.setRuleAttribute(ruleAttribute);
        }

        public static Builder create(String documentTypeId, ExtensionDefinition.Builder ruleAttribute) {
            return new Builder(documentTypeId, ruleAttribute);
        }

        public static Builder create(DocumentTypeAttributeContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create(contract.getDocumentTypeId(), ExtensionDefinition.Builder.create(contract.getRuleAttribute()));
            builder.setOrderIndex(contract.getOrderIndex());
            builder.setId(contract.getId());
            return builder;
        }

        public DocumentTypeAttribute build() {
            return new DocumentTypeAttribute(this);
        }

        @Override
        public ExtensionDefinition.Builder getRuleAttribute() {
            return this.ruleAttribute;
        }

        @Override
        public String getDocumentTypeId() {
            return this.documentTypeId;
        }

        @Override
        public int getOrderIndex() {
            return this.orderIndex;
        }

        public String getId() {
            return this.id;
        }

        public void setRuleAttribute(ExtensionDefinition.Builder ruleAttribute) {
            if (ruleAttribute == null) {
                throw new IllegalArgumentException("ruleAttribute is null");
            }
            this.ruleAttribute = ruleAttribute;
        }

        public void setDocumentTypeId(String documentTypeId) {
            if (StringUtils.isEmpty((String)documentTypeId)) {
                throw new IllegalArgumentException("documentTypeId is empty");
            }
            this.documentTypeId = documentTypeId;
        }

        public void setOrderIndex(int orderIndex) {
            this.orderIndex = orderIndex;
        }

        public void setId(String id) {
            if (StringUtils.isWhitespace((String)id)) {
                throw new IllegalArgumentException("id is blank");
            }
            this.id = id;
        }
    }

    static class Elements {
        static final String RULE_ATTRIBUTE = "ruleAttribute";
        static final String DOCUMENT_TYPE_ID = "documentTypeId";
        static final String ORDER_INDEX = "orderIndex";
        static final String ID = "id";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "documentTypeAttribute";
        static final String TYPE_NAME = "DocumentTypeAttributeType";

        Constants() {
        }
    }
}

