/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.api.note;

import java.util.List;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.KewApiConstants;

@WebService(name = "noteService", targetNamespace = KewApiConstants.Namespaces.KEW_NAMESPACE_2_0)
@SOAPBinding(style = SOAPBinding.Style.DOCUMENT, use = SOAPBinding.Use.LITERAL, parameterStyle = SOAPBinding.ParameterStyle.WRAPPED)
public interface NoteService {

    @WebMethod(operationName = "getNotes")
    @WebResult(name = "notes")
    @XmlElementWrapper(name = "notes", required = true)
    @XmlElement(name = "note", required = false)
    List<Note> getNotes(@WebParam(name = "documentId") String documentId) throws RiceIllegalArgumentException;

    @WebMethod(operationName = "getNote")
    @WebResult(name = "note")
    @XmlElement(name = "note", required = false)
    Note getNote(@WebParam(name = "noteId") String noteId) throws RiceIllegalArgumentException;

    @WebMethod(operationName = "createNote")
    @WebResult(name = "note")
    @XmlElement(name = "note", required = true)
    Note createNote(@WebParam(name = "note") Note note) throws RiceIllegalArgumentException;

    @WebMethod(operationName = "update")
    @WebResult(name = "note")
    @XmlElement(name = "note", required = true)
    Note updateNote(@WebParam(name = "note") Note note) throws RiceIllegalArgumentException;

    @WebMethod(operationName = "deleteNote")
    @WebResult(name = "note")
    @XmlElement(name = "note", required = true)
    Note deleteNote(@WebParam(name = "noteId") String noteId) throws RiceIllegalArgumentException;

}
