/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.api.doctype;

import org.kuali.rice.core.api.mo.common.Identifiable;
import org.kuali.rice.core.api.mo.common.Versioned;

/**
 * Contract interface for the definition of a workflow process.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface ProcessDefinitionContract extends Identifiable, Versioned {
    
    String getName();
    
    String getDocumentTypeId();

    /**
     * @return the initial route node for the process.  May be null.
     */
    RouteNodeContract getInitialRouteNode();
    
    boolean isInitial();

}
