/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.api.doctype;

import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.core.api.mo.common.Identifiable;
import org.kuali.rice.core.api.mo.common.Versioned;

import java.util.List;
import java.util.Map;

public interface DocumentTypeContract extends Identifiable, Versioned, GloballyUnique {

    String getName();

    Integer getDocumentTypeVersion();

    String getLabel();

    String getDescription();

    String getParentId();

    boolean isActive();

    String getHelpDefinitionUrl();

    String getDocSearchHelpUrl();

    String getPostProcessorName();

    String getApplicationId();

    boolean isCurrent();

    String getBlanketApproveGroupId();

    String getSuperUserGroupId();
    
    Map<DocumentTypePolicy, String> getPolicies();

    List<? extends DocumentTypeAttributeContract> getDocumentTypeAttributes();
        
    String getResolvedDocumentHandlerUrl();

    String getUnresolvedDocHandlerUrl();

    /**
     * @since 2.1.3
     * @return the custom DocumentTypePermissionService class or service name configured for the doc type
     */
    String getAuthorizer();

}
