/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.api.action;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import org.kuali.rice.core.api.mo.common.Coded;
import org.kuali.rice.kew.api.KewApiConstants;

@XmlRootElement(name = "actionRequestStatus")
@XmlType(name = "ActionRequestStatusType")
@XmlEnum
public enum ActionRequestStatus implements Coded {

	/**
	 * Code to indicate the request has been satisfied
	 */
    @XmlEnumValue(KewApiConstants.ActionRequestStatusVals.DONE)
        DONE(KewApiConstants.ActionRequestStatusVals.DONE, "DONE"),
    
    /**
     * Code to indicate the request is currently active
     */
    @XmlEnumValue(KewApiConstants.ActionRequestStatusVals.ACTIVATED)
            ACTIVATED(KewApiConstants.ActionRequestStatusVals.ACTIVATED, "ACTIVATED"),
    
    /**
     * Code to indicate the request has not been activated
     */
    @XmlEnumValue(KewApiConstants.ActionRequestStatusVals.INITIALIZED)
            INITIALIZED(KewApiConstants.ActionRequestStatusVals.INITIALIZED, "INITIALIZED");
	
	private final String code;
	private final String label;
	
	ActionRequestStatus(String code, String label) {
		this.code = code;
		this.label = label;
	}
	
	@Override
	public String getCode() {
		return code;
	}
	
	public String getLabel() {
		return label;
	}
	
	public static ActionRequestStatus fromCode(String code) {
		if (code == null) {
			return null;
		}
		for (ActionRequestStatus request : values()) {
			if (request.code.equals(code)) {
				return request;
			}
		}
		throw new IllegalArgumentException("Failed to locate the ActionRequestStatus with the given code: " + code);
	}
	
}
