/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api;

import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.module.RunMode;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kew.api.action.ActionInvocationQueue;
import org.kuali.rice.kew.api.action.RolePokerQueue;
import org.kuali.rice.kew.api.action.WorkflowDocumentActionsService;
import org.kuali.rice.kew.api.actionlist.ActionListService;
import org.kuali.rice.kew.api.doctype.DocumentTypeService;
import org.kuali.rice.kew.api.document.DocumentOrchestrationQueue;
import org.kuali.rice.kew.api.document.DocumentProcessingQueue;
import org.kuali.rice.kew.api.document.DocumentRefreshQueue;
import org.kuali.rice.kew.api.document.WorkflowDocumentService;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeIndexingQueue;
import org.kuali.rice.kew.api.extension.ExtensionRepositoryService;
import org.kuali.rice.kew.api.group.GroupMembershipChangeQueue;
import org.kuali.rice.kew.api.mail.ImmediateEmailReminderQueue;
import org.kuali.rice.kew.api.note.NoteService;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowService;
import org.kuali.rice.kew.api.preferences.PreferencesService;
import org.kuali.rice.kew.api.repository.type.KewTypeRepositoryService;
import org.kuali.rice.kew.api.responsibility.ResponsibilityChangeQueue;
import org.kuali.rice.kew.api.rule.RuleService;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.api.messaging.AsyncWrappable;

public class KewApiServiceLocator {
    public static final String WORKFLOW_DOCUMENT_ACTIONS_SERVICE = "rice.kew.workflowDocumentActionsService";
    public static final String WORKFLOW_DOCUMENT_SERVICE = "rice.kew.workflowDocumentService";
    public static final String ACTION_LIST_SERVICE = "rice.kew.actionListService";
    public static final String DOCUMENT_TYPE_SERVICE = "rice.kew.documentTypeService";
    public static final String NOTE_SERVICE = "rice.kew.noteService";
    public static final String EXTENSION_REPOSITORY_SERVICE = "rice.kew.extensionRepositoryService";
    public static final String RULE_SERVICE = "rice.kew.ruleService";
    public static final String KEW_TYPE_REPOSITORY_SERVICE = "rice.kew.kewTypeRepositoryService";
    public static final String PEOPLE_FLOW_SERVICE = "rice.kew.peopleFlowService";
    public static final String PREFERENCES_SERVICE = "rice.kew.preferencesService";
    public static final String KEW_RUN_MODE_PROPERTY = "kew.mode";
    public static final String STANDALONE_APPLICATION_ID = "standalone.application.id";
    public static final QName DOCUMENT_ATTRIBUTE_INDEXING_QUEUE_QNAME = new QName("http://rice.kuali.org/kew/v2_0", "documentAttributeIndexingQueue");
    private static final String DOCUMENT_ATTRIBUTE_INDEXING_QUEUE = "rice.kew.documentAttributeIndexingQueue";
    public static final QName GROUP_MEMBERSHIP_CHANGE_QUEUE_QNAME = new QName("http://rice.kuali.org/kew/v2_0", "groupMembershipChangeQueue");
    private static final String GROUP_MEMBERSHIP_CHANGE_QUEUE = "rice.kew.groupMembershipChangeQueue";
    public static final QName IMMEDIATE_EMAIL_REMINDER_QUEUE_QNAME = new QName("http://rice.kuali.org/kew/v2_0", "immediateEmailReminderQueue");
    private static final String IMMEDIATE_EMAIL_REMINDER_QUEUE = "rice.kew.immediateEmailReminderQueue";
    public static final QName RESPONSIBILITY_CHANGE_QUEUE_QNAME = new QName("http://rice.kuali.org/kew/v2_0", "responsibilityChangeQueue");
    private static final String RESPONSIBILITY_CHANGE_QUEUE = "rice.kew.responsibilityChangeQueue";
    public static final QName DOCUMENT_REFRESH_QUEUE_QNAME = new QName("http://rice.kuali.org/kew/v2_0", "documentRefreshQueue");
    private static final String DOCUMENT_REFRESH_QUEUE = "rice.kew.documentRefreshQueue";
    public static final QName ROLE_POKER_QUEUE_QNAME = new QName("http://rice.kuali.org/kew/v2_0", "rolePokerQueue");
    private static final String ROLE_POKER_QUEUE = "rice.kew.rolePokerQueue";
    public static final QName DOCUMENT_PROCESSING_QUEUE_QNAME = new QName("http://rice.kuali.org/kew/v2_0", "documentProcessingQueue");
    private static final String DOCUMENT_PROCESSING_QUEUE = "rice.kew.documentProcessingQueue";
    public static final QName DOCUMENT_ORCHESTRATION_QUEUE_QNAME = new QName("http://rice.kuali.org/kew/v2_0", "documentOrchestrationQueue");
    private static final String DOCUMENT_ORCHESTRATION_QUEUE = "rice.kew.documentOrchestrationQueue";
    public static final QName ACTION_INVOCATION_QUEUE_QNAME = new QName("http://rice.kuali.org/kew/v2_0", "actionInvocationQueue");
    private static final String ACTION_INVOCATION_QUEUE = "rice.kew.actionInvocationQueue";

    static <T> T getService(String serviceName) {
        return (T)GlobalResourceLoader.getService((String)serviceName);
    }

    public static WorkflowDocumentActionsService getWorkflowDocumentActionsService() {
        RunMode kewRunMode = RunMode.valueOf((String)ConfigContext.getCurrentContextConfig().getProperty(KEW_RUN_MODE_PROPERTY));
        if (kewRunMode == RunMode.REMOTE || kewRunMode == RunMode.THIN) {
            String standaloneApplicationId = ConfigContext.getCurrentContextConfig().getProperty(STANDALONE_APPLICATION_ID);
            return KewApiServiceLocator.getWorkflowDocumentActionsService(standaloneApplicationId);
        }
        return (WorkflowDocumentActionsService)KewApiServiceLocator.getService(WORKFLOW_DOCUMENT_ACTIONS_SERVICE);
    }

    public static WorkflowDocumentActionsService getWorkflowDocumentActionsService(String applicationId) {
        if (!StringUtils.isEmpty((String)applicationId)) {
            QName qN = new QName("http://rice.kuali.org/kew/v2_0", "workflowDocumentActionsService");
            return (WorkflowDocumentActionsService)KsbApiServiceLocator.getServiceBus().getService(qN, applicationId);
        }
        return KewApiServiceLocator.getWorkflowDocumentActionsService();
    }

    public static WorkflowDocumentService getWorkflowDocumentService() {
        return (WorkflowDocumentService)KewApiServiceLocator.getService(WORKFLOW_DOCUMENT_SERVICE);
    }

    public static ActionListService getActionListService() {
        return (ActionListService)KewApiServiceLocator.getService(ACTION_LIST_SERVICE);
    }

    public static DocumentTypeService getDocumentTypeService() {
        return (DocumentTypeService)KewApiServiceLocator.getService(DOCUMENT_TYPE_SERVICE);
    }

    public static NoteService getNoteService() {
        return (NoteService)KewApiServiceLocator.getService(NOTE_SERVICE);
    }

    public static RuleService getRuleService() {
        return (RuleService)KewApiServiceLocator.getService(RULE_SERVICE);
    }

    public static ExtensionRepositoryService getExtensionRepositoryService() {
        return (ExtensionRepositoryService)KewApiServiceLocator.getService(EXTENSION_REPOSITORY_SERVICE);
    }

    public static KewTypeRepositoryService getKewTypeRepositoryService() {
        return (KewTypeRepositoryService)KewApiServiceLocator.getService(KEW_TYPE_REPOSITORY_SERVICE);
    }

    public static PeopleFlowService getPeopleFlowService() {
        return (PeopleFlowService)KewApiServiceLocator.getService(PEOPLE_FLOW_SERVICE);
    }

    public static PreferencesService getPreferencesService() {
        return (PreferencesService)KewApiServiceLocator.getService(PREFERENCES_SERVICE);
    }

    public static DocumentAttributeIndexingQueue getDocumentAttributeIndexingQueue() {
        return KewApiServiceLocator.getDocumentAttributeIndexingQueue(null);
    }

    public static DocumentAttributeIndexingQueue getDocumentAttributeIndexingQueue(String applicationId) {
        return (DocumentAttributeIndexingQueue)KewApiServiceLocator.getWrapped(DOCUMENT_ATTRIBUTE_INDEXING_QUEUE, DOCUMENT_ATTRIBUTE_INDEXING_QUEUE_QNAME, applicationId);
    }

    public static GroupMembershipChangeQueue getGroupMembershipChangeQueue() {
        return (GroupMembershipChangeQueue)KewApiServiceLocator.getWrapped(GROUP_MEMBERSHIP_CHANGE_QUEUE, GROUP_MEMBERSHIP_CHANGE_QUEUE_QNAME, null);
    }

    public static ResponsibilityChangeQueue getResponsibilityChangeQueue() {
        return (ResponsibilityChangeQueue)KewApiServiceLocator.getWrapped(RESPONSIBILITY_CHANGE_QUEUE, RESPONSIBILITY_CHANGE_QUEUE_QNAME, null);
    }

    public static ImmediateEmailReminderQueue getImmediateEmailReminderQueue() {
        return (ImmediateEmailReminderQueue)KewApiServiceLocator.getWrapped(IMMEDIATE_EMAIL_REMINDER_QUEUE, IMMEDIATE_EMAIL_REMINDER_QUEUE_QNAME, null);
    }

    public static DocumentProcessingQueue getDocumentProcessingQueue(String applicationId) {
        return (DocumentProcessingQueue)KewApiServiceLocator.getWrapped(DOCUMENT_PROCESSING_QUEUE, DOCUMENT_PROCESSING_QUEUE_QNAME, applicationId);
    }

    public static ActionInvocationQueue getActionInvocationProcessorService(String applicationId) {
        return (ActionInvocationQueue)KewApiServiceLocator.getWrapped(ACTION_INVOCATION_QUEUE, ACTION_INVOCATION_QUEUE_QNAME, applicationId);
    }

    public static DocumentOrchestrationQueue getDocumentOrchestrationQueue(String applicationId) {
        return (DocumentOrchestrationQueue)KewApiServiceLocator.getWrapped(DOCUMENT_ORCHESTRATION_QUEUE, DOCUMENT_ORCHESTRATION_QUEUE_QNAME, applicationId);
    }

    public static RolePokerQueue getRolePokerQueue(String applicationId) {
        return (RolePokerQueue)KewApiServiceLocator.getWrapped(ROLE_POKER_QUEUE, ROLE_POKER_QUEUE_QNAME, applicationId);
    }

    public static DocumentRefreshQueue getDocumentRequeuerService(String applicationId) {
        return (DocumentRefreshQueue)KewApiServiceLocator.getWrapped(DOCUMENT_REFRESH_QUEUE, DOCUMENT_REFRESH_QUEUE_QNAME, applicationId);
    }

    private static <T> T getWrapped(String name, QName qName, String applicationId) {
        T service = KewApiServiceLocator.getService(name);
        return (T)(service instanceof AsyncWrappable ? ((AsyncWrappable)service).wrap(qName, applicationId) : service);
    }
}

