/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kew.api.action.RoutingReportActionToTake;
import org.kuali.rice.kew.api.action.RoutingReportActionToTakeContract;
import org.kuali.rice.kew.api.action.RoutingReportCriteriaContract;
import org.w3c.dom.Element;

@XmlRootElement(name="routingReportCriteria")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="RoutingReportCriteriaType", propOrder={"documentId", "targetNodeName", "targetPrincipalIds", "routingPrincipalId", "documentTypeName", "xmlContent", "ruleTemplateNames", "nodeNames", "actionsToTake", "activateRequests", "flattenNodes", "_futureElements"})
public final class RoutingReportCriteria
extends AbstractDataTransferObject
implements RoutingReportCriteriaContract {
    @XmlElement(name="documentId", required=false)
    private final String documentId;
    @XmlElement(name="targetNodeName", required=false)
    private final String targetNodeName;
    @XmlElementWrapper(name="targetPrincipalIds", required=false)
    @XmlElement(name="targetPrincipalId", required=false)
    private final List<String> targetPrincipalIds;
    @XmlElement(name="routingPrincipalId", required=false)
    private final String routingPrincipalId;
    @XmlElement(name="documentTypeName", required=false)
    private final String documentTypeName;
    @XmlElement(name="xmlContent", required=false)
    private final String xmlContent;
    @XmlElementWrapper(name="ruleTemplateNames", required=false)
    @XmlElement(name="ruleTemplateName", required=false)
    private final List<String> ruleTemplateNames;
    @XmlElementWrapper(name="nodeNames", required=false)
    @XmlElement(name="nodeName", required=false)
    private final List<String> nodeNames;
    @XmlElementWrapper(name="actionsToTake", required=false)
    @XmlElement(name="actionToTake", required=false)
    private final List<RoutingReportActionToTake> actionsToTake;
    @XmlElement(name="activateRequests", required=false)
    private final boolean activateRequests;
    @XmlElement(name="flattenNodes", required=false)
    private final boolean flattenNodes;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private RoutingReportCriteria() {
        this.documentId = null;
        this.targetNodeName = null;
        this.targetPrincipalIds = null;
        this.routingPrincipalId = null;
        this.documentTypeName = null;
        this.xmlContent = null;
        this.ruleTemplateNames = null;
        this.nodeNames = null;
        this.actionsToTake = null;
        this.flattenNodes = false;
        this.activateRequests = false;
    }

    private RoutingReportCriteria(Builder builder) {
        this.documentId = builder.getDocumentId();
        this.targetNodeName = builder.getTargetNodeName();
        this.targetPrincipalIds = builder.getTargetPrincipalIds();
        this.routingPrincipalId = builder.getRoutingPrincipalId();
        this.documentTypeName = builder.getDocumentTypeName();
        this.xmlContent = builder.getXmlContent();
        this.ruleTemplateNames = builder.getRuleTemplateNames();
        this.nodeNames = builder.getNodeNames();
        if (builder.getActionsToTake() != null) {
            ArrayList<RoutingReportActionToTake> actions = new ArrayList<RoutingReportActionToTake>();
            for (RoutingReportActionToTake.Builder actionBuilder : builder.getActionsToTake()) {
                actions.add(actionBuilder.build());
            }
            this.actionsToTake = actions;
        } else {
            this.actionsToTake = Collections.emptyList();
        }
        this.flattenNodes = builder.isFlattenNodes();
        this.activateRequests = builder.isActivateRequests();
    }

    @Override
    public String getDocumentId() {
        return this.documentId;
    }

    @Override
    public String getTargetNodeName() {
        return this.targetNodeName;
    }

    @Override
    public List<String> getTargetPrincipalIds() {
        return this.targetPrincipalIds;
    }

    @Override
    public String getRoutingPrincipalId() {
        return this.routingPrincipalId;
    }

    @Override
    public String getDocumentTypeName() {
        return this.documentTypeName;
    }

    @Override
    public String getXmlContent() {
        return this.xmlContent;
    }

    @Override
    public List<String> getRuleTemplateNames() {
        return this.ruleTemplateNames;
    }

    @Override
    public List<String> getNodeNames() {
        return this.nodeNames;
    }

    public List<RoutingReportActionToTake> getActionsToTake() {
        return this.actionsToTake;
    }

    @Override
    public boolean isActivateRequests() {
        return this.activateRequests;
    }

    @Override
    public boolean isFlattenNodes() {
        return this.flattenNodes;
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    RoutingReportCriteriaContract {
        private String documentId;
        private String targetNodeName;
        private List<String> targetPrincipalIds;
        private String routingPrincipalId;
        private String documentTypeName;
        private String xmlContent;
        private List<String> ruleTemplateNames;
        private List<String> nodeNames;
        private List<RoutingReportActionToTake.Builder> actionsToTake;
        private boolean activateRequests;
        private boolean flattenNodes;

        private Builder(String documentId, String targetNodeName) {
            this.setDocumentId(documentId);
            this.setTargetNodeName(targetNodeName);
        }

        private Builder(String documentTypeName) {
            this.setDocumentTypeName(documentTypeName);
        }

        public static Builder createByDocumentTypeName(String documentTypeName) {
            return new Builder(documentTypeName);
        }

        public static Builder createByDocumentId(String documentId) {
            return new Builder(documentId, null);
        }

        public static Builder createByDocumentIdAndTargetNodeName(String documentId, String targetNodeName) {
            return new Builder(documentId, targetNodeName);
        }

        public static Builder create(RoutingReportCriteriaContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.createByDocumentIdAndTargetNodeName(contract.getDocumentId(), contract.getTargetNodeName());
            builder.setDocumentId(contract.getDocumentId());
            builder.setTargetNodeName(contract.getTargetNodeName());
            builder.setTargetPrincipalIds(contract.getTargetPrincipalIds());
            builder.setRoutingPrincipalId(contract.getRoutingPrincipalId());
            builder.setDocumentTypeName(contract.getDocumentTypeName());
            builder.setXmlContent(contract.getXmlContent());
            builder.setRuleTemplateNames(contract.getRuleTemplateNames());
            builder.setNodeNames(contract.getNodeNames());
            if (contract.getActionsToTake() != null) {
                ArrayList<RoutingReportActionToTake.Builder> actionsToTake = new ArrayList<RoutingReportActionToTake.Builder>();
                for (RoutingReportActionToTakeContract routingReportActionToTakeContract : contract.getActionsToTake()) {
                    actionsToTake.add(RoutingReportActionToTake.Builder.create(routingReportActionToTakeContract));
                }
                builder.setActionsToTake(actionsToTake);
            }
            builder.setActivateRequests(contract.isActivateRequests());
            builder.setFlattenNodes(contract.isFlattenNodes());
            return builder;
        }

        public RoutingReportCriteria build() {
            return new RoutingReportCriteria(this);
        }

        @Override
        public String getDocumentId() {
            return this.documentId;
        }

        @Override
        public String getTargetNodeName() {
            return this.targetNodeName;
        }

        @Override
        public List<String> getTargetPrincipalIds() {
            return this.targetPrincipalIds;
        }

        @Override
        public String getRoutingPrincipalId() {
            return this.routingPrincipalId;
        }

        @Override
        public String getDocumentTypeName() {
            return this.documentTypeName;
        }

        @Override
        public String getXmlContent() {
            return this.xmlContent;
        }

        @Override
        public List<String> getRuleTemplateNames() {
            return this.ruleTemplateNames;
        }

        @Override
        public List<String> getNodeNames() {
            return this.nodeNames;
        }

        public List<RoutingReportActionToTake.Builder> getActionsToTake() {
            return this.actionsToTake;
        }

        @Override
        public boolean isActivateRequests() {
            return this.activateRequests;
        }

        @Override
        public boolean isFlattenNodes() {
            return this.flattenNodes;
        }

        public void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        public void setTargetNodeName(String targetNodeName) {
            this.targetNodeName = targetNodeName;
        }

        public void setTargetPrincipalIds(List<String> targetPrincipalIds) {
            this.targetPrincipalIds = Collections.unmodifiableList(targetPrincipalIds);
        }

        public void setRoutingPrincipalId(String routingPrincipalId) {
            this.routingPrincipalId = routingPrincipalId;
        }

        public void setDocumentTypeName(String documentTypeName) {
            this.documentTypeName = documentTypeName;
        }

        public void setXmlContent(String xmlContent) {
            this.xmlContent = xmlContent;
        }

        public void setRuleTemplateNames(List<String> ruleTemplateNames) {
            this.ruleTemplateNames = Collections.unmodifiableList(ruleTemplateNames);
        }

        public void setNodeNames(List<String> nodeNames) {
            this.nodeNames = Collections.unmodifiableList(nodeNames);
        }

        public void setActionsToTake(List<RoutingReportActionToTake.Builder> actionsToTake) {
            this.actionsToTake = Collections.unmodifiableList(actionsToTake);
        }

        public void setActivateRequests(boolean activateRequests) {
            this.activateRequests = activateRequests;
        }

        public void setFlattenNodes(boolean flattenNodes) {
            this.flattenNodes = flattenNodes;
        }
    }

    static class Elements {
        static final String DOCUMENT_ID = "documentId";
        static final String TARGET_NODE_NAME = "targetNodeName";
        static final String TARGET_PRINCIPAL_IDS = "targetPrincipalIds";
        static final String TARGET_PRINCIPAL_ID = "targetPrincipalId";
        static final String ROUTING_PRINCIPAL_ID = "routingPrincipalId";
        static final String DOCUMENT_TYPE_NAME = "documentTypeName";
        static final String XML_CONTENT = "xmlContent";
        static final String RULE_TEMPLATE_NAMES = "ruleTemplateNames";
        static final String RULE_TEMPLATE_NAME = "ruleTemplateName";
        static final String NODE_NAMES = "nodeNames";
        static final String NODE_NAME = "nodeName";
        static final String ACTIONS_TO_TAKE = "actionsToTake";
        static final String ACTION_TO_TAKE = "actionToTake";
        static final String ACTIVATE_REQUESTS = "activateRequests";
        static final String FLATTEN_NODES = "flattenNodes";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "routingReportCriteria";
        static final String TYPE_NAME = "RoutingReportCriteriaType";

        Constants() {
        }
    }
}

