/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.rule;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kew.api.rule.RuleDelegation;
import org.kuali.rice.kew.api.rule.RuleDelegationContract;
import org.kuali.rice.kew.api.rule.RuleResponsibilityContract;
import org.w3c.dom.Element;

@XmlRootElement(name="ruleResponsibility")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="RuleResponsibilityType", propOrder={"id", "priority", "responsibilityId", "actionRequestedCd", "approvePolicy", "principalId", "groupId", "roleName", "delegationRules", "usingRole", "usingGroup", "usingPrincipal", "versionNumber", "objectId", "_futureElements"})
public final class RuleResponsibility
extends AbstractDataTransferObject
implements RuleResponsibilityContract {
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="priority", required=false)
    private final Integer priority;
    @XmlElement(name="responsibilityId", required=true)
    private final String responsibilityId;
    @XmlElement(name="actionRequestedCd", required=false)
    private final String actionRequestedCd;
    @XmlElement(name="approvePolicy", required=false)
    private final String approvePolicy;
    @XmlElement(name="principalId", required=false)
    private final String principalId;
    @XmlElement(name="groupId", required=false)
    private final String groupId;
    @XmlElement(name="roleName", required=false)
    private final String roleName;
    @XmlElementWrapper(name="delegationRules", required=false)
    @XmlElement(name="delegationRule", required=false)
    private final List<RuleDelegation> delegationRules;
    @XmlElement(name="usingRole", required=false)
    private final boolean usingRole;
    @XmlElement(name="usingPrincipal", required=false)
    private final boolean usingPrincipal;
    @XmlElement(name="usingGroup", required=false)
    private final boolean usingGroup;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElement(name="objectId", required=false)
    private final String objectId;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private RuleResponsibility() {
        this.id = null;
        this.priority = null;
        this.responsibilityId = null;
        this.actionRequestedCd = null;
        this.approvePolicy = null;
        this.principalId = null;
        this.groupId = null;
        this.roleName = null;
        this.delegationRules = null;
        this.usingGroup = false;
        this.usingPrincipal = false;
        this.usingRole = false;
        this.versionNumber = null;
        this.objectId = null;
    }

    private RuleResponsibility(Builder builder) {
        this.id = builder.getId();
        this.priority = builder.getPriority();
        this.responsibilityId = builder.getResponsibilityId();
        this.actionRequestedCd = builder.getActionRequestedCd();
        this.approvePolicy = builder.getApprovePolicy();
        this.principalId = builder.getPrincipalId();
        this.groupId = builder.getGroupId();
        this.roleName = builder.getRoleName();
        if (CollectionUtils.isNotEmpty(builder.getDelegationRules())) {
            ArrayList<RuleDelegation> delegationList = new ArrayList<RuleDelegation>();
            for (RuleDelegation.Builder b : builder.getDelegationRules()) {
                delegationList.add(b.build());
            }
            this.delegationRules = delegationList;
        } else {
            this.delegationRules = Collections.emptyList();
        }
        this.usingGroup = builder.isUsingGroup();
        this.usingPrincipal = builder.isUsingPrincipal();
        this.usingRole = builder.isUsingRole();
        this.versionNumber = builder.getVersionNumber();
        this.objectId = builder.getObjectId();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public Integer getPriority() {
        return this.priority;
    }

    @Override
    public String getResponsibilityId() {
        return this.responsibilityId;
    }

    @Override
    public String getActionRequestedCd() {
        return this.actionRequestedCd;
    }

    @Override
    public String getApprovePolicy() {
        return this.approvePolicy;
    }

    @Override
    public String getPrincipalId() {
        return this.principalId;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getRoleName() {
        return this.roleName;
    }

    public List<RuleDelegation> getDelegationRules() {
        return this.delegationRules;
    }

    @Override
    public boolean isUsingRole() {
        return this.usingRole;
    }

    @Override
    public boolean isUsingPrincipal() {
        return this.usingPrincipal;
    }

    @Override
    public boolean isUsingGroup() {
        return this.usingGroup;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public String getRoleAttributeName() {
        return this.getRoleName().substring(0, this.getRoleName().indexOf("!"));
    }

    public String getResolvedRoleName() {
        if (this.isUsingRole()) {
            return this.getRoleName().substring(this.getRoleName().indexOf("!") + 1, this.getRoleName().length());
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof RuleResponsibilityContract)) {
            return false;
        }
        RuleResponsibilityContract resp = (RuleResponsibilityContract)o;
        return StringUtils.equals((String)this.getPrincipalId(), (String)resp.getPrincipalId()) && StringUtils.equals((String)this.getRoleName(), (String)resp.getRoleName()) && StringUtils.equals((String)this.getGroupId(), (String)resp.getGroupId()) && StringUtils.equals((String)this.getActionRequestedCd(), (String)resp.getActionRequestedCd()) && ObjectUtils.equals((Object)this.getPriority(), (Object)resp.getPriority()) && StringUtils.equals((String)this.getApprovePolicy(), (String)resp.getApprovePolicy());
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    RuleResponsibilityContract {
        private String id;
        private Integer priority;
        private String responsibilityId;
        private String actionRequestedCd;
        private String approvePolicy;
        private String principalId;
        private String groupId;
        private String roleName;
        private List<RuleDelegation.Builder> delegationRules;
        private boolean usingRole = false;
        private boolean usingPrincipal = false;
        private boolean usingGroup = false;
        private Long versionNumber;
        private String objectId;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(RuleResponsibilityContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create();
            builder.setId(contract.getId());
            builder.setPriority(contract.getPriority());
            builder.setResponsibilityId(contract.getResponsibilityId());
            builder.setActionRequestedCd(contract.getActionRequestedCd());
            builder.setApprovePolicy(contract.getApprovePolicy());
            builder.setPrincipalId(contract.getPrincipalId());
            builder.setGroupId(contract.getGroupId());
            builder.setRoleName(contract.getRoleName());
            if (CollectionUtils.isNotEmpty(contract.getDelegationRules())) {
                ArrayList<RuleDelegation.Builder> builders = new ArrayList<RuleDelegation.Builder>();
                for (RuleDelegationContract ruleDelegationContract : contract.getDelegationRules()) {
                    builders.add(RuleDelegation.Builder.create(ruleDelegationContract));
                }
                builder.setDelegationRules(builders);
            } else {
                builder.setDelegationRules(Collections.emptyList());
            }
            builder.setUsingGroup(contract.isUsingGroup());
            builder.setUsingPrincipal(contract.isUsingPrincipal());
            builder.setUsingRole(contract.isUsingRole());
            builder.setVersionNumber(contract.getVersionNumber());
            builder.setObjectId(contract.getObjectId());
            return builder;
        }

        public RuleResponsibility build() {
            return new RuleResponsibility(this);
        }

        public String getId() {
            return this.id;
        }

        @Override
        public Integer getPriority() {
            return this.priority;
        }

        @Override
        public String getResponsibilityId() {
            return this.responsibilityId;
        }

        @Override
        public String getActionRequestedCd() {
            return this.actionRequestedCd;
        }

        @Override
        public String getApprovePolicy() {
            return this.approvePolicy;
        }

        @Override
        public String getPrincipalId() {
            return this.principalId;
        }

        @Override
        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public String getRoleName() {
            return this.roleName;
        }

        public List<RuleDelegation.Builder> getDelegationRules() {
            return this.delegationRules;
        }

        @Override
        public boolean isUsingRole() {
            return this.usingRole;
        }

        @Override
        public boolean isUsingPrincipal() {
            return this.usingPrincipal;
        }

        @Override
        public boolean isUsingGroup() {
            return this.usingGroup;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public void setId(String id) {
            if (StringUtils.isWhitespace((String)id)) {
                throw new IllegalArgumentException("id is whitespace");
            }
            this.id = id;
        }

        public void setPriority(Integer priority) {
            this.priority = priority;
        }

        public void setResponsibilityId(String responsibilityId) {
            this.responsibilityId = responsibilityId;
        }

        public void setActionRequestedCd(String actionRequestedCd) {
            this.actionRequestedCd = actionRequestedCd;
        }

        public void setApprovePolicy(String approvePolicy) {
            this.approvePolicy = approvePolicy;
        }

        public void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public void setDelegationRules(List<RuleDelegation.Builder> delegationRules) {
            this.delegationRules = delegationRules;
        }

        public void setUsingRole(boolean usingRole) {
            this.usingRole = usingRole;
        }

        public void setUsingPrincipal(boolean usingPrincipal) {
            this.usingPrincipal = usingPrincipal;
        }

        public void setUsingGroup(boolean usingGroup) {
            this.usingGroup = usingGroup;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/kew/v2_0/RuleResponsibilityType";
    }

    static class Elements {
        static final String ID = "id";
        static final String PRIORITY = "priority";
        static final String RESPONSIBILITY_ID = "responsibilityId";
        static final String ACTION_REQUESTED_CD = "actionRequestedCd";
        static final String APPROVE_POLICY = "approvePolicy";
        static final String PRINCIPAL_ID = "principalId";
        static final String GROUP_ID = "groupId";
        static final String ROLE_NAME = "roleName";
        static final String DELEGATION_RULES = "delegationRules";
        static final String DELEGATION_RULE = "delegationRule";
        static final String USING_ROLE = "usingRole";
        static final String USING_PRINCIPAL = "usingPrincipal";
        static final String USING_GROUP = "usingGroup";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "ruleResponsibility";
        static final String TYPE_NAME = "RuleResponsibilityType";

        Constants() {
        }
    }
}

