/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.extension;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.util.jaxb.MapStringStringAdapter;
import org.kuali.rice.kew.api.extension.ExtensionDefinitionContract;
import org.w3c.dom.Element;

@XmlRootElement(name="extensionDefinition")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="ExtensionDefinitionType", propOrder={"id", "name", "applicationId", "label", "description", "type", "resourceDescriptor", "configuration", "versionNumber", "_futureElements"})
public final class ExtensionDefinition
extends AbstractDataTransferObject
implements ExtensionDefinitionContract {
    private static final long serialVersionUID = 6234968409006917945L;
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="name", required=true)
    private final String name;
    @XmlElement(name="applicationId", required=false)
    private final String applicationId;
    @XmlElement(name="label", required=false)
    private final String label;
    @XmlElement(name="description", required=false)
    private final String description;
    @XmlElement(name="type", required=true)
    private final String type;
    @XmlElement(name="resourceDescriptor", required=true)
    private final String resourceDescriptor;
    @XmlElement(name="configuration", required=false)
    @XmlJavaTypeAdapter(value=MapStringStringAdapter.class)
    private final Map<String, String> configuration;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private ExtensionDefinition() {
        this.id = null;
        this.name = null;
        this.applicationId = null;
        this.label = null;
        this.description = null;
        this.type = null;
        this.resourceDescriptor = null;
        this.configuration = null;
        this.versionNumber = null;
    }

    private ExtensionDefinition(Builder builder) {
        this.id = builder.getId();
        this.name = builder.getName();
        this.applicationId = builder.getApplicationId();
        this.label = builder.getLabel();
        this.description = builder.getDescription();
        this.type = builder.getType();
        this.resourceDescriptor = builder.getResourceDescriptor();
        this.configuration = builder.getConfiguration() == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, String>(builder.getConfiguration()));
        this.versionNumber = builder.getVersionNumber();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getResourceDescriptor() {
        return this.resourceDescriptor;
    }

    @Override
    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    ExtensionDefinitionContract {
        private String id;
        private String name;
        private String applicationId;
        private String label;
        private String description;
        private String type;
        private String resourceDescriptor;
        private Map<String, String> configuration;
        private Long versionNumber;

        private Builder(String name, String type, String resourceDescriptor) {
            this.setName(name);
            this.setType(type);
            this.setResourceDescriptor(resourceDescriptor);
            this.setConfiguration(new HashMap<String, String>());
        }

        public static Builder create(String name, String type, String resourceDescriptor) {
            return new Builder(name, type, resourceDescriptor);
        }

        public static Builder create(ExtensionDefinitionContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create(contract.getName(), contract.getType(), contract.getResourceDescriptor());
            builder.setId(contract.getId());
            builder.setApplicationId(contract.getApplicationId());
            builder.setLabel(contract.getLabel());
            builder.setDescription(contract.getDescription());
            builder.setConfiguration(contract.getConfiguration());
            builder.setVersionNumber(contract.getVersionNumber());
            return builder;
        }

        public ExtensionDefinition build() {
            return new ExtensionDefinition(this);
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String getResourceDescriptor() {
            return this.resourceDescriptor;
        }

        @Override
        public Map<String, String> getConfiguration() {
            return this.configuration;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setName(String name) {
            if (StringUtils.isBlank((String)name)) {
                throw new IllegalArgumentException("name was null or blank");
            }
            this.name = name;
        }

        public void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setType(String type) {
            if (StringUtils.isBlank((String)type)) {
                throw new IllegalArgumentException("type was null or blank");
            }
            this.type = type;
        }

        public void setResourceDescriptor(String resourceDescriptor) {
            if (StringUtils.isBlank((String)resourceDescriptor)) {
                throw new IllegalArgumentException("descriptor was null or blank");
            }
            this.resourceDescriptor = resourceDescriptor;
        }

        public void setConfiguration(Map<String, String> configuration) {
            this.configuration = configuration;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/kew/v2_0/ExtensionDefinitionType";
    }

    static class Elements {
        static final String ID = "id";
        static final String NAME = "name";
        static final String APPLICATION_ID = "applicationId";
        static final String LABEL = "label";
        static final String DESCRIPTION = "description";
        static final String TYPE = "type";
        static final String RESOURCE_DESCRIPTOR = "resourceDescriptor";
        static final String CONFIGURATION = "configuration";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "extensionDefinition";
        static final String TYPE_NAME = "ExtensionDefinitionType";

        Constants() {
        }
    }
}

