/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.framework.document.search;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections.CollectionUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.mo.ModelObjectUtils;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.core.api.uif.RemotableAttributeFieldContract;
import org.kuali.rice.kew.framework.document.search.DocumentSearchResultSetConfigurationContract;
import org.kuali.rice.kew.framework.document.search.StandardResultField;
import org.w3c.dom.Element;

@XmlRootElement(name="documentSearchResultSetConfiguration")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="DocumentSearchResultSetConfigurationType", propOrder={"overrideSearchableAttributes", "customFieldNamesToAdd", "standardResultFieldsToRemove", "additionalAttributeFields", "_futureElements"})
public final class DocumentSearchResultSetConfiguration
extends AbstractDataTransferObject
implements DocumentSearchResultSetConfigurationContract {
    @XmlElement(name="overrideSearchableAttributes", required=true)
    private final boolean overrideSearchableAttributes;
    @XmlElementWrapper(name="customFieldNamesToAdd", required=false)
    @XmlElement(name="customFieldNameToAdd", required=false)
    private final List<String> customFieldNamesToAdd;
    @XmlElementWrapper(name="standardResultFieldsToRemove", required=false)
    @XmlElement(name="standardResultFieldToRemove", required=false)
    private final List<StandardResultField> standardResultFieldsToRemove;
    @XmlElementWrapper(name="additionalAttributeFields", required=false)
    @XmlElement(name="additionalAttributeField", required=false)
    private final List<RemotableAttributeField> additionalAttributeFields;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private DocumentSearchResultSetConfiguration() {
        this.overrideSearchableAttributes = false;
        this.customFieldNamesToAdd = null;
        this.standardResultFieldsToRemove = null;
        this.additionalAttributeFields = null;
    }

    private DocumentSearchResultSetConfiguration(Builder builder) {
        this.overrideSearchableAttributes = builder.isOverrideSearchableAttributes();
        this.customFieldNamesToAdd = ModelObjectUtils.createImmutableCopy(builder.getCustomFieldNamesToAdd());
        this.standardResultFieldsToRemove = ModelObjectUtils.createImmutableCopy(builder.getStandardResultFieldsToRemove());
        this.additionalAttributeFields = ModelObjectUtils.buildImmutableCopy(builder.getAdditionalAttributeFields());
    }

    @Override
    public boolean isOverrideSearchableAttributes() {
        return this.overrideSearchableAttributes;
    }

    @Override
    public List<String> getCustomFieldNamesToAdd() {
        return this.customFieldNamesToAdd;
    }

    @Override
    public List<StandardResultField> getStandardResultFieldsToRemove() {
        return this.standardResultFieldsToRemove;
    }

    public List<RemotableAttributeField> getAdditionalAttributeFields() {
        return this.additionalAttributeFields;
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    DocumentSearchResultSetConfigurationContract {
        private boolean overrideSearchableAttributes;
        private List<String> customFieldNamesToAdd;
        private List<StandardResultField> standardResultFieldsToRemove;
        private List<RemotableAttributeField.Builder> additionalAttributeFields;

        private Builder() {
            this.setOverrideSearchableAttributes(false);
            this.setCustomFieldNamesToAdd(new ArrayList<String>());
            this.setStandardResultFieldsToRemove(new ArrayList<StandardResultField>());
            this.setAdditionalAttributeFields(new ArrayList<RemotableAttributeField.Builder>());
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(DocumentSearchResultSetConfigurationContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create();
            builder.setOverrideSearchableAttributes(contract.isOverrideSearchableAttributes());
            if (CollectionUtils.isNotEmpty(contract.getCustomFieldNamesToAdd())) {
                builder.setCustomFieldNamesToAdd(new ArrayList<String>(contract.getCustomFieldNamesToAdd()));
            }
            if (CollectionUtils.isNotEmpty(contract.getStandardResultFieldsToRemove())) {
                builder.setStandardResultFieldsToRemove(new ArrayList<StandardResultField>(contract.getStandardResultFieldsToRemove()));
            }
            if (CollectionUtils.isNotEmpty(contract.getAdditionalAttributeFields())) {
                for (RemotableAttributeFieldContract remotableAttributeFieldContract : contract.getAdditionalAttributeFields()) {
                    builder.getAdditionalAttributeFields().add(RemotableAttributeField.Builder.create((RemotableAttributeFieldContract)remotableAttributeFieldContract));
                }
            }
            return builder;
        }

        public DocumentSearchResultSetConfiguration build() {
            return new DocumentSearchResultSetConfiguration(this);
        }

        @Override
        public boolean isOverrideSearchableAttributes() {
            return this.overrideSearchableAttributes;
        }

        @Override
        public List<String> getCustomFieldNamesToAdd() {
            return this.customFieldNamesToAdd;
        }

        @Override
        public List<StandardResultField> getStandardResultFieldsToRemove() {
            return this.standardResultFieldsToRemove;
        }

        public List<RemotableAttributeField.Builder> getAdditionalAttributeFields() {
            return this.additionalAttributeFields;
        }

        public void setOverrideSearchableAttributes(boolean overrideSearchableAttributes) {
            this.overrideSearchableAttributes = overrideSearchableAttributes;
        }

        public void setCustomFieldNamesToAdd(List<String> customFieldNamesToAdd) {
            this.customFieldNamesToAdd = customFieldNamesToAdd;
        }

        public void setStandardResultFieldsToRemove(List<StandardResultField> standardResultFieldsToRemove) {
            this.standardResultFieldsToRemove = standardResultFieldsToRemove;
        }

        public void setAdditionalAttributeFields(List<RemotableAttributeField.Builder> additionalAttributeFields) {
            this.additionalAttributeFields = additionalAttributeFields;
        }
    }

    static class Elements {
        static final String OVERRIDE_SEARCHABLE_ATTRIBUTES = "overrideSearchableAttributes";
        static final String CUSTOM_FIELD_NAMES_TO_ADD = "customFieldNamesToAdd";
        static final String CUSTOM_FIELD_NAME_TO_ADD = "customFieldNameToAdd";
        static final String STANDARD_RESULT_FIELDS_TO_REMOVE = "standardResultFieldsToRemove";
        static final String STANDARD_RESULT_FIELD_TO_REMOVE = "standardResultFieldToRemove";
        static final String ADDITIONAL_ATTRIBUTE_FIELDS = "additionalAttributeFields";
        static final String ADDITIONAL_ATTRIBUTE_FIELD = "additionalAttributeField";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "documentSearchResultSetConfiguration";
        static final String TYPE_NAME = "DocumentSearchResultSetConfigurationType";

        Constants() {
        }
    }
}

