/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.framework.document.search;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

/**
 * An enumeration which defines the set of available document search customizations.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@XmlRootElement(name = "documentSearchCustomization")
@XmlType(name = "DocumentSearchCustomizationType")
@XmlEnum
public enum DocumentSearchCustomization {

    /**
     * Customization of the document search criteria.
     */
    CRITERIA,

    /**
     * Customization of clearing of the document search criteria.
     */
    CLEAR_CRITERIA,

    /**
     * Customization of document search results.
     */
    RESULTS,

    /**
     * Customization of the document search result attribute fields.
     */
    RESULT_SET_FIELDS;

}
