/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.framework.postprocessor;

public class DocumentRouteStatusChange implements IDocumentEvent {

	private static final long serialVersionUID = -5170568498563302803L;
	private String appDocId;
	private String documentId;
	private String newRouteStatus;
	private String oldRouteStatus;

	public DocumentRouteStatusChange(String documentId, String appDocId, String oldStatus, String newStatus) {
		this.documentId = documentId;
		this.appDocId = appDocId;
		this.newRouteStatus = newStatus;
		this.oldRouteStatus = oldStatus;
	}

	@Override
    public String getDocumentEventCode() {
		return ROUTE_STATUS_CHANGE;
	}

	@Override
    public String getDocumentId() {
		return documentId;
	}

	public String getNewRouteStatus() {
		return newRouteStatus;
	}

	public String getOldRouteStatus() {
		return oldRouteStatus;
	}

	@Override
    public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("DocumentId ").append(documentId);
		buffer.append(" changing from routeStatus ").append(oldRouteStatus);
		buffer.append(" to routeStatus ").append(newRouteStatus);

		return buffer.toString();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.kuali.rice.kew.IDocumentEvent#getAppDocId()
	 */
	@Override
    public String getAppDocId() {
		return this.appDocId;
	}
}
