/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.impl.peopleflow;

import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * A values finder for returning KEW rule delegation type codes.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class DelegationTypeValuesFinder extends KeyValuesBase {

	private static final List<KeyValue> C_DELEGATION_TYPES;
	static {
		final List<KeyValue> delegationTypes = new ArrayList<KeyValue>();
		for (String delegationType : KimConstants.KimUIConstants.DELEGATION_TYPES.keySet()) {
			delegationTypes.add(new ConcreteKeyValue(delegationType, KimConstants.KimUIConstants.DELEGATION_TYPES.get(delegationType)));
		}
		C_DELEGATION_TYPES = Collections.unmodifiableList(delegationTypes);
	}
	
	@Override
	public List<KeyValue> getKeyValues() {
		return C_DELEGATION_TYPES;
	}

}
