/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.identity.address;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.util.jaxb.DateTimeAdapter;
import org.kuali.rice.kim.api.identity.CodedAttribute;
import org.kuali.rice.kim.api.identity.address.EntityAddressContract;
import org.w3c.dom.Element;

@XmlRootElement(name="entityAddress")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="EntityAddressType", propOrder={"id", "entityTypeCode", "entityId", "addressType", "attentionLine", "line1", "line2", "line3", "city", "stateProvinceCode", "postalCode", "countryCode", "attentionLineUnmasked", "line1Unmasked", "line2Unmasked", "line3Unmasked", "cityUnmasked", "stateProvinceCodeUnmasked", "postalCodeUnmasked", "countryCodeUnmasked", "addressFormat", "modifiedDate", "validatedDate", "validated", "noteMessage", "suppressAddress", "defaultValue", "active", "versionNumber", "objectId", "_futureElements"})
public final class EntityAddress
extends AbstractDataTransferObject
implements EntityAddressContract {
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="entityTypeCode", required=false)
    private final String entityTypeCode;
    @XmlElement(name="entityId", required=false)
    private final String entityId;
    @XmlElement(name="addressType", required=false)
    private final CodedAttribute addressType;
    @XmlElement(name="attentionLine", required=false)
    private final String attentionLine;
    @XmlElement(name="line1", required=false)
    private final String line1;
    @XmlElement(name="line2", required=false)
    private final String line2;
    @XmlElement(name="line3", required=false)
    private final String line3;
    @XmlElement(name="city", required=false)
    private final String city;
    @XmlElement(name="stateProvinceCode", required=false)
    private final String stateProvinceCode;
    @XmlElement(name="postalCode", required=false)
    private final String postalCode;
    @XmlElement(name="countryCode", required=false)
    private final String countryCode;
    @XmlElement(name="attentionLineUnmasked", required=false)
    private final String attentionLineUnmasked;
    @XmlElement(name="line1Unmasked", required=false)
    private final String line1Unmasked;
    @XmlElement(name="line2Unmasked", required=false)
    private final String line2Unmasked;
    @XmlElement(name="line3Unmasked", required=false)
    private final String line3Unmasked;
    @XmlElement(name="cityUnmasked", required=false)
    private final String cityUnmasked;
    @XmlElement(name="stateProvinceCodeUnmasked", required=false)
    private final String stateProvinceCodeUnmasked;
    @XmlElement(name="postalCodeUnmasked", required=false)
    private final String postalCodeUnmasked;
    @XmlElement(name="countryCodeUnmasked", required=false)
    private final String countryCodeUnmasked;
    @XmlElement(name="addressFormat", required=false)
    private final String addressFormat;
    @XmlElement(name="modifiedDate", required=false)
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private final DateTime modifiedDate;
    @XmlElement(name="validatedDate", required=false)
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private final DateTime validatedDate;
    @XmlElement(name="validated", required=false)
    private final boolean validated;
    @XmlElement(name="noteMessage", required=false)
    private final String noteMessage;
    @XmlElement(name="suppressAddress", required=false)
    private final boolean suppressAddress;
    @XmlElement(name="defaultValue", required=false)
    private final boolean defaultValue;
    @XmlElement(name="active", required=false)
    private final boolean active;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElement(name="objectId", required=false)
    private final String objectId;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private EntityAddress() {
        this.entityId = null;
        this.entityTypeCode = null;
        this.addressType = null;
        this.attentionLine = null;
        this.line1 = null;
        this.line2 = null;
        this.line3 = null;
        this.city = null;
        this.stateProvinceCode = null;
        this.postalCode = null;
        this.countryCode = null;
        this.attentionLineUnmasked = null;
        this.line1Unmasked = null;
        this.line2Unmasked = null;
        this.line3Unmasked = null;
        this.cityUnmasked = null;
        this.stateProvinceCodeUnmasked = null;
        this.postalCodeUnmasked = null;
        this.countryCodeUnmasked = null;
        this.addressFormat = null;
        this.modifiedDate = null;
        this.validatedDate = null;
        this.validated = true;
        this.noteMessage = null;
        this.suppressAddress = false;
        this.defaultValue = false;
        this.versionNumber = null;
        this.objectId = null;
        this.active = false;
        this.id = null;
    }

    private EntityAddress(Builder builder) {
        this.entityId = builder.getEntityId();
        this.entityTypeCode = builder.getEntityTypeCode();
        this.addressType = builder.getAddressType() != null ? builder.getAddressType().build() : null;
        this.attentionLine = builder.getAttentionLine();
        this.line1 = builder.getLine1();
        this.line2 = builder.getLine2();
        this.line3 = builder.getLine3();
        this.city = builder.getCity();
        this.stateProvinceCode = builder.getStateProvinceCode();
        this.postalCode = builder.getPostalCode();
        this.countryCode = builder.getCountryCode();
        this.attentionLineUnmasked = builder.getAttentionLineUnmasked();
        this.line1Unmasked = builder.getLine1Unmasked();
        this.line2Unmasked = builder.getLine2Unmasked();
        this.line3Unmasked = builder.getLine3Unmasked();
        this.cityUnmasked = builder.getCityUnmasked();
        this.stateProvinceCodeUnmasked = builder.getStateProvinceCodeUnmasked();
        this.postalCodeUnmasked = builder.getPostalCodeUnmasked();
        this.countryCodeUnmasked = builder.getCountryCodeUnmasked();
        this.addressFormat = builder.getAddressFormat();
        this.modifiedDate = builder.getModifiedDate();
        this.validatedDate = builder.getValidatedDate();
        this.validated = builder.isValidated();
        this.noteMessage = builder.getNoteMessage();
        this.suppressAddress = builder.isSuppressAddress();
        this.defaultValue = builder.isDefaultValue();
        this.versionNumber = builder.getVersionNumber();
        this.objectId = builder.getObjectId();
        this.active = builder.isActive();
        this.id = builder.getId();
    }

    @Override
    public String getEntityId() {
        return this.entityId;
    }

    @Override
    public String getEntityTypeCode() {
        return this.entityTypeCode;
    }

    @Override
    public CodedAttribute getAddressType() {
        return this.addressType;
    }

    @Override
    public String getAttentionLine() {
        return this.attentionLine;
    }

    @Override
    public String getLine1() {
        return this.line1;
    }

    @Override
    public String getLine2() {
        return this.line2;
    }

    @Override
    public String getLine3() {
        return this.line3;
    }

    @Override
    public String getCity() {
        return this.city;
    }

    @Override
    public String getStateProvinceCode() {
        return this.stateProvinceCode;
    }

    @Override
    public String getPostalCode() {
        return this.postalCode;
    }

    @Override
    public String getCountryCode() {
        return this.countryCode;
    }

    @Override
    public String getAttentionLineUnmasked() {
        return this.attentionLineUnmasked;
    }

    @Override
    public String getLine1Unmasked() {
        return this.line1Unmasked;
    }

    @Override
    public String getLine2Unmasked() {
        return this.line2Unmasked;
    }

    @Override
    public String getLine3Unmasked() {
        return this.line3Unmasked;
    }

    @Override
    public String getCityUnmasked() {
        return this.cityUnmasked;
    }

    @Override
    public String getStateProvinceCodeUnmasked() {
        return this.stateProvinceCodeUnmasked;
    }

    @Override
    public String getPostalCodeUnmasked() {
        return this.postalCodeUnmasked;
    }

    @Override
    public String getCountryCodeUnmasked() {
        return this.countryCodeUnmasked;
    }

    @Override
    public String getAddressFormat() {
        return this.addressFormat;
    }

    @Override
    public DateTime getModifiedDate() {
        return this.modifiedDate;
    }

    @Override
    public DateTime getValidatedDate() {
        return this.validatedDate;
    }

    @Override
    public boolean isValidated() {
        return this.validated;
    }

    @Override
    public String getNoteMessage() {
        return this.noteMessage;
    }

    @Override
    public boolean isSuppressAddress() {
        return this.suppressAddress;
    }

    public boolean isDefaultValue() {
        return this.defaultValue;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getId() {
        return this.id;
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    EntityAddressContract {
        private String entityId;
        private String entityTypeCode;
        private CodedAttribute.Builder addressType;
        private String attentionLineUnmasked;
        private String line1Unmasked;
        private String line2Unmasked;
        private String line3Unmasked;
        private String cityUnmasked;
        private String stateProvinceCodeUnmasked;
        private String postalCodeUnmasked;
        private String countryCodeUnmasked;
        private String addressFormat;
        private DateTime modifiedDate;
        private DateTime validatedDate;
        private boolean validated;
        private String noteMessage;
        private boolean suppressAddress;
        private boolean defaultValue;
        private Long versionNumber;
        private String objectId;
        private boolean active;
        private String id;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(EntityAddressContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create();
            builder.setEntityId(contract.getEntityId());
            builder.setSuppressAddress(contract.isSuppressAddress());
            builder.setEntityTypeCode(contract.getEntityTypeCode());
            if (contract.getAddressType() != null) {
                builder.setAddressType(CodedAttribute.Builder.create(contract.getAddressType()));
            }
            builder.setAttentionLine(contract.getAttentionLineUnmasked());
            builder.setLine1(contract.getLine1Unmasked());
            builder.setLine2(contract.getLine2Unmasked());
            builder.setLine3(contract.getLine3Unmasked());
            builder.setCity(contract.getCityUnmasked());
            builder.setStateProvinceCode(contract.getStateProvinceCodeUnmasked());
            builder.setPostalCode(contract.getPostalCodeUnmasked());
            builder.setCountryCode(contract.getCountryCodeUnmasked());
            builder.setAddressFormat(contract.getAddressFormat());
            builder.setModifiedDate(contract.getModifiedDate());
            builder.setValidatedDate(contract.getValidatedDate());
            builder.setValidated(contract.isValidated());
            builder.setNoteMessage(contract.getNoteMessage());
            builder.setDefaultValue(contract.isDefaultValue());
            builder.setVersionNumber(contract.getVersionNumber());
            builder.setObjectId(contract.getObjectId());
            builder.setActive(contract.isActive());
            builder.setId(contract.getId());
            return builder;
        }

        public EntityAddress build() {
            return new EntityAddress(this);
        }

        @Override
        public String getEntityId() {
            return this.entityId;
        }

        @Override
        public String getEntityTypeCode() {
            return this.entityTypeCode;
        }

        @Override
        public CodedAttribute.Builder getAddressType() {
            return this.addressType;
        }

        @Override
        public String getAttentionLine() {
            if (this.isSuppressAddress()) {
                return "Xxxxxx";
            }
            return this.attentionLineUnmasked;
        }

        @Override
        public String getLine1() {
            if (this.isSuppressAddress()) {
                return "Xxxxxx";
            }
            return this.line1Unmasked;
        }

        @Override
        public String getLine2() {
            if (this.isSuppressAddress()) {
                return "Xxxxxx";
            }
            return this.line2Unmasked;
        }

        @Override
        public String getLine3() {
            if (this.isSuppressAddress()) {
                return "Xxxxxx";
            }
            return this.line3Unmasked;
        }

        @Override
        public String getCity() {
            if (this.isSuppressAddress()) {
                return "Xxxxxx";
            }
            return this.cityUnmasked;
        }

        @Override
        public String getStateProvinceCode() {
            if (this.isSuppressAddress()) {
                return "XX";
            }
            return this.stateProvinceCodeUnmasked;
        }

        @Override
        public String getPostalCode() {
            if (this.isSuppressAddress()) {
                return "00000";
            }
            return this.postalCodeUnmasked;
        }

        @Override
        public String getCountryCode() {
            if (this.isSuppressAddress()) {
                return "XX";
            }
            return this.countryCodeUnmasked;
        }

        @Override
        public String getAttentionLineUnmasked() {
            return this.attentionLineUnmasked;
        }

        @Override
        public String getLine1Unmasked() {
            return this.line1Unmasked;
        }

        @Override
        public String getLine2Unmasked() {
            return this.line2Unmasked;
        }

        @Override
        public String getLine3Unmasked() {
            return this.line3Unmasked;
        }

        @Override
        public String getCityUnmasked() {
            return this.cityUnmasked;
        }

        @Override
        public String getStateProvinceCodeUnmasked() {
            return this.stateProvinceCodeUnmasked;
        }

        @Override
        public String getPostalCodeUnmasked() {
            return this.postalCodeUnmasked;
        }

        @Override
        public String getCountryCodeUnmasked() {
            return this.countryCodeUnmasked;
        }

        @Override
        public String getAddressFormat() {
            return this.addressFormat;
        }

        @Override
        public DateTime getModifiedDate() {
            return this.modifiedDate;
        }

        @Override
        public DateTime getValidatedDate() {
            return this.validatedDate;
        }

        @Override
        public boolean isValidated() {
            return this.validated;
        }

        @Override
        public String getNoteMessage() {
            return this.noteMessage;
        }

        @Override
        public boolean isSuppressAddress() {
            return this.suppressAddress;
        }

        public boolean isDefaultValue() {
            return this.defaultValue;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public boolean isActive() {
            return this.active;
        }

        public String getId() {
            return this.id;
        }

        public void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        public void setEntityTypeCode(String entityTypeCode) {
            this.entityTypeCode = entityTypeCode;
        }

        public void setAddressType(CodedAttribute.Builder addressType) {
            this.addressType = addressType;
        }

        public void setAttentionLine(String attnLine) {
            this.attentionLineUnmasked = attnLine;
        }

        public void setLine1(String line1) {
            this.line1Unmasked = line1;
        }

        public void setLine2(String line2) {
            this.line2Unmasked = line2;
        }

        public void setLine3(String line3) {
            this.line3Unmasked = line3;
        }

        public void setCity(String city) {
            this.cityUnmasked = city;
        }

        public void setStateProvinceCode(String stateProvinceCode) {
            this.stateProvinceCodeUnmasked = stateProvinceCode;
        }

        public void setPostalCode(String postalCode) {
            this.postalCodeUnmasked = postalCode;
        }

        public void setCountryCode(String countryCode) {
            this.countryCodeUnmasked = countryCode;
        }

        public void setAddressFormat(String addressFormat) {
            this.addressFormat = addressFormat;
        }

        public void setModifiedDate(DateTime modifiedDate) {
            this.modifiedDate = modifiedDate;
        }

        public void setValidatedDate(DateTime validatedDate) {
            this.validatedDate = validatedDate;
        }

        public void setValidated(boolean validated) {
            this.validated = validated;
        }

        public void setNoteMessage(String noteMessage) {
            this.noteMessage = noteMessage;
        }

        private void setSuppressAddress(boolean suppressAddress) {
            this.suppressAddress = suppressAddress;
        }

        public void setDefaultValue(boolean defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setId(String id) {
            if (StringUtils.isWhitespace((String)id)) {
                throw new IllegalArgumentException("id is blank");
            }
            this.id = id;
        }
    }

    static class Elements {
        static final String ENTITY_ID = "entityId";
        static final String ENTITY_TYPE_CODE = "entityTypeCode";
        static final String ADDRESS_TYPE = "addressType";
        static final String ATTENTION_LINE = "attentionLine";
        static final String LINE1 = "line1";
        static final String LINE2 = "line2";
        static final String LINE3 = "line3";
        static final String CITY = "city";
        static final String STATE_PROVINCE_CODE = "stateProvinceCode";
        static final String POSTAL_CODE = "postalCode";
        static final String COUNTRY_CODE = "countryCode";
        static final String ATTENTION_LINE_UNMASKED = "attentionLineUnmasked";
        static final String LINE1_UNMASKED = "line1Unmasked";
        static final String LINE2_UNMASKED = "line2Unmasked";
        static final String LINE3_UNMASKED = "line3Unmasked";
        static final String CITY_UNMASKED = "cityUnmasked";
        static final String STATE_PROVINCE_CODE_UNMASKED = "stateProvinceCodeUnmasked";
        static final String POSTAL_CODE_UNMASKED = "postalCodeUnmasked";
        static final String COUNTRY_CODE_UNMASKED = "countryCodeUnmasked";
        static final String ADDRESS_FORMAT = "addressFormat";
        static final String MODIFIED_DATE = "modifiedDate";
        static final String VALIDATED_DATE = "validatedDate";
        static final String VALIDATED = "validated";
        static final String NOTE_MESSAGE = "noteMessage";
        static final String SUPPRESS_ADDRESS = "suppressAddress";
        static final String DEFAULT_VALUE = "defaultValue";
        static final String ACTIVE = "active";
        static final String ID = "id";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "entityAddress";
        static final String TYPE_NAME = "EntityAddressType";

        Constants() {
        }
    }
}

