/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.api.responsibility;


import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.core.api.mo.common.Identifiable;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;
import org.kuali.rice.kim.api.common.template.TemplateContract;

import java.util.Map;

/**
 * This is the contract for a Responsibility. Represents a single Responsibility within the system.
 * 
 * Responsibilities are attached to roles. All authorization checks should be done against Responsibilities,
 * never against roles or groups.
 *  
 */
public interface ResponsibilityContract extends Versioned, GloballyUnique, Inactivatable, Identifiable {
    
    /**
     * The namespace code that this Responsibility belongs too.
     *
     * @return namespaceCode
     */
    String getNamespaceCode();
    
    /**
     * The name of the Responsibility.
     *
     * @return name
     */
    String getName();
    
    /**
     * The description of the Responsibility.
     *
     * @return description
     */
	String getDescription();

    /**
     * The Template referenced by the Responsibility.
     * 
     * @return templateId
     */
	TemplateContract getTemplate();
	
   /** 
	 * Attributes for a Responsibility.
	 * 
	 * @return attributes
	 */
    Map<String, String> getAttributes();
}
