/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.identity.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliation;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliationContract;
import org.kuali.rice.kim.api.identity.citizenship.EntityCitizenship;
import org.kuali.rice.kim.api.identity.citizenship.EntityCitizenshipContract;
import org.kuali.rice.kim.api.identity.employment.EntityEmployment;
import org.kuali.rice.kim.api.identity.employment.EntityEmploymentContract;
import org.kuali.rice.kim.api.identity.entity.EntityContract;
import org.kuali.rice.kim.api.identity.external.EntityExternalIdentifier;
import org.kuali.rice.kim.api.identity.external.EntityExternalIdentifierContract;
import org.kuali.rice.kim.api.identity.name.EntityName;
import org.kuali.rice.kim.api.identity.name.EntityNameContract;
import org.kuali.rice.kim.api.identity.personal.EntityBioDemographics;
import org.kuali.rice.kim.api.identity.personal.EntityEthnicity;
import org.kuali.rice.kim.api.identity.personal.EntityEthnicityContract;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.kim.api.identity.privacy.EntityPrivacyPreferences;
import org.kuali.rice.kim.api.identity.residency.EntityResidency;
import org.kuali.rice.kim.api.identity.residency.EntityResidencyContract;
import org.kuali.rice.kim.api.identity.type.EntityTypeContactInfo;
import org.kuali.rice.kim.api.identity.type.EntityTypeContactInfoContract;
import org.kuali.rice.kim.api.identity.visa.EntityVisa;
import org.kuali.rice.kim.api.identity.visa.EntityVisaContract;
import org.w3c.dom.Element;

@XmlRootElement(name="entity")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="EntityType", propOrder={"id", "principals", "entityTypeContactInfos", "externalIdentifiers", "affiliations", "names", "employmentInformation", "privacyPreferences", "bioDemographics", "citizenships", "primaryEmployment", "defaultAffiliation", "defaultName", "ethnicities", "residencies", "visas", "versionNumber", "objectId", "active", "_futureElements"})
public final class Entity
extends AbstractDataTransferObject
implements EntityContract {
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElementWrapper(name="principals", required=false)
    @XmlElement(name="principal", required=false)
    private final List<Principal> principals;
    @XmlElementWrapper(name="entityTypeContactInfos", required=false)
    @XmlElement(name="entityTypeContactInfo", required=false)
    private final List<EntityTypeContactInfo> entityTypeContactInfos;
    @XmlElementWrapper(name="externalIdentifiers", required=false)
    @XmlElement(name="externalIdentifier", required=false)
    private final List<EntityExternalIdentifier> externalIdentifiers;
    @XmlElementWrapper(name="affiliations", required=false)
    @XmlElement(name="affiliation", required=false)
    private final List<EntityAffiliation> affiliations;
    @XmlElementWrapper(name="names", required=false)
    @XmlElement(name="name", required=false)
    private final List<EntityName> names;
    @XmlElementWrapper(name="employmentInformation", required=false)
    @XmlElement(name="employment", required=false)
    private final List<EntityEmployment> employmentInformation;
    @XmlElement(name="privacyPreferences", required=false)
    private final EntityPrivacyPreferences privacyPreferences;
    @XmlElement(name="bioDemographics", required=false)
    private final EntityBioDemographics bioDemographics;
    @XmlElementWrapper(name="citizenships", required=false)
    @XmlElement(name="citizenship", required=false)
    private final List<EntityCitizenship> citizenships;
    @XmlElement(name="primaryEmployment", required=false)
    private final EntityEmployment primaryEmployment;
    @XmlElement(name="defaultAffiliation", required=false)
    private final EntityAffiliation defaultAffiliation;
    @XmlElement(name="defaultName", required=false)
    private final EntityName defaultName;
    @XmlElementWrapper(name="ethnicities", required=false)
    @XmlElement(name="ethnicity", required=false)
    private final List<EntityEthnicity> ethnicities;
    @XmlElementWrapper(name="residencies", required=false)
    @XmlElement(name="residency", required=false)
    private final List<EntityResidency> residencies;
    @XmlElementWrapper(name="visas", required=false)
    @XmlElement(name="visa", required=false)
    private final List<EntityVisa> visas;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElement(name="objectId", required=false)
    private final String objectId;
    @XmlElement(name="active", required=false)
    private final boolean active;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private Entity() {
        this.principals = null;
        this.entityTypeContactInfos = null;
        this.externalIdentifiers = null;
        this.affiliations = null;
        this.names = null;
        this.employmentInformation = null;
        this.privacyPreferences = null;
        this.bioDemographics = null;
        this.citizenships = null;
        this.primaryEmployment = null;
        this.defaultAffiliation = null;
        this.defaultName = null;
        this.ethnicities = null;
        this.residencies = null;
        this.visas = null;
        this.versionNumber = null;
        this.objectId = null;
        this.active = false;
        this.id = null;
    }

    private Entity(Builder builder) {
        this.principals = new ArrayList<Principal>();
        if (CollectionUtils.isNotEmpty(builder.getPrincipals())) {
            for (Principal.Builder principal : builder.getPrincipals()) {
                this.principals.add(principal.build());
            }
        }
        this.entityTypeContactInfos = new ArrayList<EntityTypeContactInfo>();
        if (CollectionUtils.isNotEmpty(builder.getEntityTypeContactInfos())) {
            for (EntityTypeContactInfo.Builder entityTypeData : builder.getEntityTypeContactInfos()) {
                this.entityTypeContactInfos.add(entityTypeData.build());
            }
        }
        this.externalIdentifiers = new ArrayList<EntityExternalIdentifier>();
        if (CollectionUtils.isNotEmpty(builder.getExternalIdentifiers())) {
            for (EntityExternalIdentifier.Builder externalId : builder.getExternalIdentifiers()) {
                this.externalIdentifiers.add(externalId.build());
            }
        }
        this.affiliations = new ArrayList<EntityAffiliation>();
        if (CollectionUtils.isNotEmpty(builder.getAffiliations())) {
            for (EntityAffiliation.Builder affiliation : builder.getAffiliations()) {
                this.affiliations.add(affiliation.build());
            }
        }
        this.names = new ArrayList<EntityName>();
        if (CollectionUtils.isNotEmpty(builder.getNames())) {
            for (EntityName.Builder name : builder.getNames()) {
                this.names.add(name.build());
            }
        }
        this.employmentInformation = new ArrayList<EntityEmployment>();
        if (CollectionUtils.isNotEmpty(builder.getEmploymentInformation())) {
            for (EntityEmployment.Builder employment : builder.getEmploymentInformation()) {
                this.employmentInformation.add(employment.build());
            }
        }
        this.privacyPreferences = builder.getPrivacyPreferences() == null ? null : builder.getPrivacyPreferences().build();
        this.bioDemographics = builder.getBioDemographics() == null ? null : builder.getBioDemographics().build();
        this.citizenships = new ArrayList<EntityCitizenship>();
        if (CollectionUtils.isNotEmpty(builder.getCitizenships())) {
            for (EntityCitizenship.Builder citizenship : builder.getCitizenships()) {
                this.citizenships.add(citizenship.build());
            }
        }
        this.primaryEmployment = builder.getPrimaryEmployment() == null ? null : builder.getPrimaryEmployment().build();
        this.defaultAffiliation = builder.getDefaultAffiliation() == null ? null : builder.getDefaultAffiliation().build();
        this.defaultName = builder.getDefaultName() == null ? null : builder.getDefaultName().build();
        this.ethnicities = new ArrayList<EntityEthnicity>();
        if (CollectionUtils.isNotEmpty(builder.getEthnicities())) {
            for (EntityEthnicity.Builder ethnicity : builder.getEthnicities()) {
                this.ethnicities.add(ethnicity.build());
            }
        }
        this.residencies = new ArrayList<EntityResidency>();
        if (CollectionUtils.isNotEmpty(builder.getResidencies())) {
            for (EntityResidency.Builder residency : builder.getResidencies()) {
                this.residencies.add(residency.build());
            }
        }
        this.visas = new ArrayList<EntityVisa>();
        if (CollectionUtils.isNotEmpty(builder.getVisas())) {
            for (EntityVisa.Builder visa : builder.getVisas()) {
                this.visas.add(visa.build());
            }
        }
        this.versionNumber = builder.getVersionNumber();
        this.objectId = builder.getObjectId();
        this.active = builder.isActive();
        this.id = builder.getId();
    }

    public List<Principal> getPrincipals() {
        return this.principals;
    }

    public List<EntityTypeContactInfo> getEntityTypeContactInfos() {
        return this.entityTypeContactInfos;
    }

    public List<EntityExternalIdentifier> getExternalIdentifiers() {
        return this.externalIdentifiers;
    }

    public List<EntityAffiliation> getAffiliations() {
        return this.affiliations;
    }

    public List<EntityName> getNames() {
        return this.names;
    }

    public List<EntityEmployment> getEmploymentInformation() {
        return this.employmentInformation;
    }

    @Override
    public EntityPrivacyPreferences getPrivacyPreferences() {
        return this.privacyPreferences;
    }

    @Override
    public EntityBioDemographics getBioDemographics() {
        return this.bioDemographics;
    }

    public List<EntityCitizenship> getCitizenships() {
        return this.citizenships;
    }

    @Override
    public EntityEmployment getPrimaryEmployment() {
        return this.primaryEmployment;
    }

    @Override
    public EntityAffiliation getDefaultAffiliation() {
        return this.defaultAffiliation;
    }

    @Override
    public EntityExternalIdentifier getEntityExternalIdentifier(String externalIdentifierTypeCode) {
        if (this.externalIdentifiers == null) {
            return null;
        }
        for (EntityExternalIdentifier externalId : this.externalIdentifiers) {
            if (!externalId.getExternalIdentifierTypeCode().equals(externalIdentifierTypeCode)) continue;
            return externalId;
        }
        return null;
    }

    @Override
    public EntityNameContract getDefaultName() {
        return this.defaultName;
    }

    public List<EntityEthnicity> getEthnicities() {
        return this.ethnicities;
    }

    public List<EntityResidency> getResidencies() {
        return this.residencies;
    }

    public List<EntityVisa> getVisas() {
        return this.visas;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public EntityTypeContactInfo getEntityTypeContactInfoByTypeCode(String entityTypeCode) {
        if (this.entityTypeContactInfos == null) {
            return null;
        }
        for (EntityTypeContactInfo entType : this.entityTypeContactInfos) {
            if (!entType.getEntityTypeCode().equals(entityTypeCode)) continue;
            return entType;
        }
        return null;
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    EntityContract {
        private List<Principal.Builder> principals;
        private List<EntityTypeContactInfo.Builder> entityTypeContactInfos;
        private List<EntityExternalIdentifier.Builder> externalIdentifiers;
        private List<EntityAffiliation.Builder> affiliations;
        private List<EntityName.Builder> names;
        private List<EntityEmployment.Builder> employmentInformation;
        private EntityPrivacyPreferences.Builder privacyPreferences;
        private EntityBioDemographics.Builder bioDemographics;
        private List<EntityCitizenship.Builder> citizenships;
        private List<EntityEthnicity.Builder> ethnicities;
        private List<EntityResidency.Builder> residencies;
        private List<EntityVisa.Builder> visas;
        private Long versionNumber;
        private String objectId;
        private boolean active;
        private String id;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(EntityContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create();
            if (contract.getPrincipals() != null) {
                ArrayList<Principal.Builder> tempPrincipals = new ArrayList<Principal.Builder>();
                for (PrincipalContract principalContract : contract.getPrincipals()) {
                    tempPrincipals.add(Principal.Builder.create(principalContract));
                }
                builder.setPrincipals(tempPrincipals);
            }
            if (contract.getEntityTypeContactInfos() != null) {
                ArrayList<EntityTypeContactInfo.Builder> tempTypeData = new ArrayList<EntityTypeContactInfo.Builder>();
                for (EntityTypeContactInfoContract entityTypeContactInfoContract : contract.getEntityTypeContactInfos()) {
                    tempTypeData.add(EntityTypeContactInfo.Builder.create(entityTypeContactInfoContract));
                }
                builder.setEntityTypes(tempTypeData);
            }
            if (contract.getExternalIdentifiers() != null) {
                ArrayList<EntityExternalIdentifier.Builder> externalIds = new ArrayList<EntityExternalIdentifier.Builder>();
                for (EntityExternalIdentifierContract entityExternalIdentifierContract : contract.getExternalIdentifiers()) {
                    externalIds.add(EntityExternalIdentifier.Builder.create(entityExternalIdentifierContract));
                }
                builder.setExternalIdentifiers(externalIds);
            }
            if (contract.getAffiliations() != null) {
                ArrayList<EntityAffiliation.Builder> affils = new ArrayList<EntityAffiliation.Builder>();
                for (EntityAffiliationContract entityAffiliationContract : contract.getAffiliations()) {
                    affils.add(EntityAffiliation.Builder.create(entityAffiliationContract));
                }
                builder.setAffiliations(affils);
            }
            if (contract.getNames() != null) {
                ArrayList<EntityName.Builder> nms = new ArrayList<EntityName.Builder>();
                for (EntityNameContract entityNameContract : contract.getNames()) {
                    nms.add(EntityName.Builder.create(entityNameContract));
                }
                builder.setNames(nms);
            }
            if (contract.getEmploymentInformation() != null) {
                ArrayList<EntityEmployment.Builder> emps = new ArrayList<EntityEmployment.Builder>();
                for (EntityEmploymentContract entityEmploymentContract : contract.getEmploymentInformation()) {
                    emps.add(EntityEmployment.Builder.create(entityEmploymentContract));
                }
                builder.setEmploymentInformation(emps);
            }
            builder.setPrivacyPreferences(contract.getPrivacyPreferences() == null ? null : EntityPrivacyPreferences.Builder.create(contract.getPrivacyPreferences()));
            builder.setBioDemographics(contract.getBioDemographics() == null ? null : EntityBioDemographics.Builder.create(contract.getBioDemographics()));
            if (contract.getCitizenships() != null) {
                ArrayList<EntityCitizenship.Builder> cits = new ArrayList<EntityCitizenship.Builder>();
                for (EntityCitizenshipContract entityCitizenshipContract : contract.getCitizenships()) {
                    cits.add(EntityCitizenship.Builder.create(entityCitizenshipContract));
                }
                builder.setCitizenships(cits);
            }
            if (contract.getEthnicities() != null) {
                ArrayList<EntityEthnicity.Builder> ethnctys = new ArrayList<EntityEthnicity.Builder>();
                for (EntityEthnicityContract entityEthnicityContract : contract.getEthnicities()) {
                    ethnctys.add(EntityEthnicity.Builder.create(entityEthnicityContract));
                }
                builder.setEthnicities(ethnctys);
            }
            if (contract.getResidencies() != null) {
                ArrayList<EntityResidency.Builder> residencyBuilders = new ArrayList<EntityResidency.Builder>();
                for (EntityResidencyContract entityResidencyContract : contract.getResidencies()) {
                    residencyBuilders.add(EntityResidency.Builder.create(entityResidencyContract));
                }
                builder.setResidencies(residencyBuilders);
            }
            if (contract.getVisas() != null) {
                ArrayList<EntityVisa.Builder> visaBuilders = new ArrayList<EntityVisa.Builder>();
                for (EntityVisaContract entityVisaContract : contract.getVisas()) {
                    visaBuilders.add(EntityVisa.Builder.create(entityVisaContract));
                }
                builder.setVisas(visaBuilders);
            }
            builder.setVersionNumber(contract.getVersionNumber());
            builder.setObjectId(contract.getObjectId());
            builder.setActive(contract.isActive());
            builder.setId(contract.getId());
            return builder;
        }

        public Entity build() {
            return new Entity(this);
        }

        public List<Principal.Builder> getPrincipals() {
            return this.principals;
        }

        public List<EntityTypeContactInfo.Builder> getEntityTypeContactInfos() {
            return this.entityTypeContactInfos;
        }

        public List<EntityExternalIdentifier.Builder> getExternalIdentifiers() {
            return this.externalIdentifiers;
        }

        public List<EntityAffiliation.Builder> getAffiliations() {
            return this.affiliations;
        }

        public List<EntityName.Builder> getNames() {
            return this.names;
        }

        public List<EntityEmployment.Builder> getEmploymentInformation() {
            return this.employmentInformation;
        }

        @Override
        public EntityPrivacyPreferences.Builder getPrivacyPreferences() {
            return this.privacyPreferences;
        }

        @Override
        public EntityBioDemographics.Builder getBioDemographics() {
            return this.bioDemographics;
        }

        public List<EntityCitizenship.Builder> getCitizenships() {
            return this.citizenships;
        }

        @Override
        public EntityTypeContactInfo.Builder getEntityTypeContactInfoByTypeCode(String entityTypeCode) {
            if (CollectionUtils.isEmpty(this.entityTypeContactInfos)) {
                return null;
            }
            for (EntityTypeContactInfo.Builder builder : this.entityTypeContactInfos) {
                if (!builder.getEntityTypeCode().equals(entityTypeCode) || !builder.isActive()) continue;
                return builder;
            }
            return null;
        }

        @Override
        public EntityEmployment.Builder getPrimaryEmployment() {
            if (CollectionUtils.isEmpty(this.employmentInformation)) {
                return null;
            }
            for (EntityEmployment.Builder builder : this.employmentInformation) {
                if (!builder.isPrimary() || !builder.isActive()) continue;
                return builder;
            }
            return null;
        }

        @Override
        public EntityAffiliation.Builder getDefaultAffiliation() {
            if (CollectionUtils.isEmpty(this.affiliations)) {
                return null;
            }
            for (EntityAffiliation.Builder builder : this.affiliations) {
                if (!builder.isDefaultValue() || !builder.isActive()) continue;
                return builder;
            }
            return null;
        }

        @Override
        public EntityExternalIdentifier.Builder getEntityExternalIdentifier(String externalIdentifierTypeCode) {
            if (CollectionUtils.isEmpty(this.externalIdentifiers)) {
                return null;
            }
            for (EntityExternalIdentifier.Builder builder : this.externalIdentifiers) {
                if (!builder.getExternalIdentifierTypeCode().equals(externalIdentifierTypeCode)) continue;
                return builder;
            }
            return null;
        }

        @Override
        public EntityName.Builder getDefaultName() {
            if (CollectionUtils.isEmpty(this.names)) {
                return null;
            }
            for (EntityName.Builder builder : this.names) {
                if (!builder.isDefaultValue() || !builder.isActive()) continue;
                return builder;
            }
            return null;
        }

        public List<EntityEthnicity.Builder> getEthnicities() {
            return this.ethnicities;
        }

        public List<EntityResidency.Builder> getResidencies() {
            return this.residencies;
        }

        public List<EntityVisa.Builder> getVisas() {
            return this.visas;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public boolean isActive() {
            return this.active;
        }

        public String getId() {
            return this.id;
        }

        public void setPrincipals(List<Principal.Builder> principals) {
            this.principals = principals;
        }

        public void setEntityTypes(List<EntityTypeContactInfo.Builder> entityTypeContactInfos) {
            this.entityTypeContactInfos = entityTypeContactInfos;
        }

        public void setExternalIdentifiers(List<EntityExternalIdentifier.Builder> externalIdentifiers) {
            this.externalIdentifiers = externalIdentifiers;
        }

        public void setAffiliations(List<EntityAffiliation.Builder> affiliations) {
            this.affiliations = affiliations;
        }

        public void setNames(List<EntityName.Builder> names) {
            this.names = names;
        }

        public void setEmploymentInformation(List<EntityEmployment.Builder> employmentInformation) {
            this.employmentInformation = employmentInformation;
        }

        public void setPrivacyPreferences(EntityPrivacyPreferences.Builder privacyPreferences) {
            this.privacyPreferences = privacyPreferences;
        }

        public void setBioDemographics(EntityBioDemographics.Builder bioDemographics) {
            this.bioDemographics = bioDemographics;
        }

        public void setCitizenships(List<EntityCitizenship.Builder> citizenships) {
            this.citizenships = citizenships;
        }

        public void setEthnicities(List<EntityEthnicity.Builder> ethnicities) {
            this.ethnicities = ethnicities;
        }

        public void setResidencies(List<EntityResidency.Builder> residencies) {
            this.residencies = residencies;
        }

        public void setVisas(List<EntityVisa.Builder> visas) {
            this.visas = visas;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setId(String id) {
            if (StringUtils.isWhitespace((String)id)) {
                throw new IllegalArgumentException("id is blank");
            }
            this.id = id;
        }
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/kim/v2_0/EntityType";
    }

    static class Elements {
        static final String PRINCIPALS = "principals";
        static final String PRINCIPAL = "principal";
        static final String ENTITY_TYPE_CONTACT_INFOS = "entityTypeContactInfos";
        static final String ENTITY_TYPE_CONTACT_INFO = "entityTypeContactInfo";
        static final String EXTERNAL_IDENTIFIERS = "externalIdentifiers";
        static final String EXTERNAL_IDENTIFIER = "externalIdentifier";
        static final String AFFILIATIONS = "affiliations";
        static final String AFFILIATION = "affiliation";
        static final String NAMES = "names";
        static final String NAME = "name";
        static final String EMPLOYMENT_INFORMATION = "employmentInformation";
        static final String EMPLOYMENT = "employment";
        static final String PRIVACY_PREFERENCES = "privacyPreferences";
        static final String BIO_DEMOGRAPHICS = "bioDemographics";
        static final String CITIZENSHIPS = "citizenships";
        static final String CITIZENSHIP = "citizenship";
        static final String PRIMARY_EMPLOYMENT = "primaryEmployment";
        static final String DEFAULT_AFFILIATION = "defaultAffiliation";
        static final String DEFAULT_NAME = "defaultName";
        static final String ETHNICITIES = "ethnicities";
        static final String ETHNICITY = "ethnicity";
        static final String RESIDENCIES = "residencies";
        static final String RESIDENCY = "residency";
        static final String VISAS = "visas";
        static final String VISA = "visa";
        static final String ACTIVE = "active";
        static final String ID = "id";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "entity";
        static final String TYPE_NAME = "EntityType";
        static final String[] HASH_CODE_EQUALS_EXCLUDE = new String[]{"_futureElements"};

        Constants() {
        }
    }
}

