/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.api.role;

import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.api.mo.common.Identifiable;
import org.kuali.rice.kim.api.common.delegate.DelegateTypeContract;

import java.util.List;
import java.util.Map;
/**
 * This is a contract for RoleMembership. Role members can be Principals, Groups, or other Roles.
 * Delegates can also be associated with a Role.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */

public interface RoleMembershipContract extends Identifiable {

    String getRoleId();

    Map<String, String> getQualifier();

    List<? extends DelegateTypeContract> getDelegates();

    String getMemberId();

    MemberType getType();

    /**
     * @return String Identifier of the role from which the group or principal was derived.
     */
    String getEmbeddedRoleId();

    /**
     * @return String value used to sort the role members into a meaningful order
     */
    String getRoleSortingCode();
}
