/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.api.type;

import org.kuali.rice.core.api.mo.common.Identifiable;
import org.kuali.rice.core.api.uif.RemotableAttributeFieldContract;

/**
 * An dynamic attribute for kim.
 */
public interface KimAttributeFieldContract extends Identifiable {

    /**
     * Gets the attribute field definition.  Cannot be null.
     *
     * @return the field
     */
    RemotableAttributeFieldContract getAttributeField();

    /**
     * Whether the attribute is a "unique" attribute according to KIM
     * @return unique status
     */
    boolean isUnique();
}
