/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.api.identity.affiliation;

import org.kuali.rice.core.api.mo.common.Defaultable;
import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.core.api.mo.common.Identifiable;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;
/**
 * This contract represents an affiliation for an Entity.
 * Each person must have at least one affiliation associated with it.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface EntityAffiliationContract extends Versioned, GloballyUnique, Defaultable, Inactivatable, Identifiable {

    /**
     * Gets this id of the parent identity object.
     * @return the identity id for this {@link EntityAddressContract}
     */
    String getEntityId();

	/**
     * Gets this {@link KimEntityAffiliation}'s type.
     * @return the type for this {@link KimEntityAffiliation}, or null if none has been assigned.
     */
	EntityAffiliationTypeContract getAffiliationType();

	/**
     * Gets this {@link KimEntityAffiliation}'s campus code.
     * @return the campus code for this {@link KimEntityAffiliation}, or null if none has been assigned.
     */
	String getCampusCode();
}
