/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.api.common.assignee;

import org.kuali.rice.kim.api.common.delegate.DelegateTypeContract;

import java.util.List;

//TODO Get a better description
/**
 * This is the contract for a Permission Assignee.
 * 
 * Permissions are attached to roles. All authorization checks should be done against permissions,
 * never against roles or groups.
 *  
 */
public interface AssigneeContract {

    /**
     * The Principal ID referenced by the Permission Assignee.
     *
     * @return principalId
     */
    String getPrincipalId();

    /**
     * The Group ID referenced by the Permission Assignee.
     * 
     * @return groupId
     */
	String getGroupId() ;
	
   /** 
	 * List of Delegates for a Permission Assignee 
	 * 
	 * @return delegates
	 */
	List<? extends DelegateTypeContract> getDelegates();
}
