/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.common.delegate;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.mo.common.active.InactivatableFromToUtils;
import org.kuali.rice.core.api.util.jaxb.DateTimeAdapter;
import org.kuali.rice.core.api.util.jaxb.MapStringStringAdapter;
import org.kuali.rice.kim.api.common.delegate.DelegateMemberContract;
import org.w3c.dom.Element;

@XmlRootElement(name="delegateMember")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="DelegateMemberType", propOrder={"delegationMemberId", "delegationId", "memberId", "roleMemberId", "typeCode", "attributes", "activeFromDate", "activeToDate", "versionNumber", "_futureElements"})
public final class DelegateMember
extends AbstractDataTransferObject
implements DelegateMemberContract {
    @XmlElement(name="delegationMemberId", required=false)
    private final String delegationMemberId;
    @XmlElement(name="delegationId", required=false)
    private final String delegationId;
    @XmlElement(name="memberId", required=false)
    private final String memberId;
    @XmlElement(name="roleMemberId", required=false)
    private final String roleMemberId;
    @XmlElement(name="typeCode", required=false)
    private final String typeCode;
    @XmlElement(name="attributes", required=false)
    @XmlJavaTypeAdapter(value=MapStringStringAdapter.class)
    private final Map<String, String> attributes;
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    @XmlElement(name="activeFromDate")
    private final DateTime activeFromDate;
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    @XmlElement(name="activeToDate")
    private final DateTime activeToDate;
    @XmlElement(name="versionNumber")
    private final Long versionNumber;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private DelegateMember() {
        this.delegationMemberId = null;
        this.delegationId = null;
        this.memberId = null;
        this.roleMemberId = null;
        this.typeCode = null;
        this.versionNumber = null;
        this.activeFromDate = null;
        this.activeToDate = null;
        this.attributes = null;
    }

    private DelegateMember(Builder builder) {
        this.delegationMemberId = builder.getDelegationMemberId();
        this.delegationId = builder.getDelegationId();
        this.memberId = builder.getMemberId();
        this.roleMemberId = builder.getRoleMemberId();
        this.typeCode = builder.getType() == null ? null : builder.getType().getCode();
        this.versionNumber = builder.getVersionNumber();
        this.activeFromDate = builder.getActiveFromDate();
        this.activeToDate = builder.getActiveToDate();
        this.attributes = builder.getAttributes();
    }

    @Override
    public String getDelegationMemberId() {
        return this.delegationMemberId;
    }

    @Override
    public String getDelegationId() {
        return this.delegationId;
    }

    @Override
    public MemberType getType() {
        return MemberType.fromCode((String)this.typeCode);
    }

    @Override
    public String getRoleMemberId() {
        return this.roleMemberId;
    }

    @Override
    public String getMemberId() {
        return this.memberId;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public DateTime getActiveFromDate() {
        return this.activeFromDate;
    }

    public DateTime getActiveToDate() {
        return this.activeToDate;
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean isActive(DateTime activeAsOfDate) {
        return InactivatableFromToUtils.isActive((DateTime)this.activeFromDate, (DateTime)this.activeToDate, (DateTime)activeAsOfDate);
    }

    public boolean isActive() {
        return InactivatableFromToUtils.isActive((DateTime)this.activeFromDate, (DateTime)this.activeToDate, null);
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    DelegateMemberContract {
        private String delegationMemberId;
        private String delegationId;
        private String memberId;
        private String roleMemberId;
        private MemberType type;
        private Map<String, String> attributes;
        private DateTime activeFromDate;
        private DateTime activeToDate;
        private Long versionNumber;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(DelegateMemberContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create();
            builder.setDelegationMemberId(contract.getDelegationMemberId());
            builder.setDelegationId(contract.getDelegationId());
            builder.setMemberId(contract.getMemberId());
            builder.setRoleMemberId(contract.getRoleMemberId());
            builder.setAttributes(contract.getAttributes());
            builder.setType(contract.getType());
            builder.setActiveFromDate(contract.getActiveFromDate());
            builder.setActiveToDate(contract.getActiveToDate());
            builder.setVersionNumber(contract.getVersionNumber());
            return builder;
        }

        public DelegateMember build() {
            return new DelegateMember(this);
        }

        @Override
        public String getDelegationMemberId() {
            return this.delegationMemberId;
        }

        public void setDelegationMemberId(String delegationMemberId) {
            if (StringUtils.isWhitespace((String)delegationMemberId)) {
                throw new IllegalArgumentException("delegationMemberId cannot be whitespace");
            }
            this.delegationMemberId = delegationMemberId;
        }

        @Override
        public String getDelegationId() {
            return this.delegationId;
        }

        public void setDelegationId(String delegationId) {
            this.delegationId = delegationId;
        }

        @Override
        public String getMemberId() {
            return this.memberId;
        }

        public void setMemberId(String memberId) {
            this.memberId = memberId;
        }

        @Override
        public String getRoleMemberId() {
            return this.roleMemberId;
        }

        public void setRoleMemberId(String roleMemberId) {
            this.roleMemberId = roleMemberId;
        }

        @Override
        public MemberType getType() {
            return this.type;
        }

        public void setType(MemberType type) {
            this.type = type;
        }

        @Override
        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes = attributes;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public DateTime getActiveFromDate() {
            return this.activeFromDate;
        }

        public void setActiveFromDate(DateTime activeFromDate) {
            this.activeFromDate = activeFromDate;
        }

        public DateTime getActiveToDate() {
            return this.activeToDate;
        }

        public void setActiveToDate(DateTime activeToDate) {
            this.activeToDate = activeToDate;
        }

        public boolean isActive(DateTime activeAsOfDate) {
            return InactivatableFromToUtils.isActive((DateTime)this.activeFromDate, (DateTime)this.activeToDate, (DateTime)activeAsOfDate);
        }

        public boolean isActive() {
            return InactivatableFromToUtils.isActive((DateTime)this.activeFromDate, (DateTime)this.activeToDate, null);
        }
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/kim/v2_0/DelegateMemberType";
    }

    static class Elements {
        static final String DELEGATION_MEMBER_ID = "delegationMemberId";
        static final String ROLE_ID = "roleId";
        static final String DELEGATION_ID = "delegationId";
        static final String MEMBER_ID = "memberId";
        static final String ATTRIBUTES = "attributes";
        static final String ROLE_MEMBER_ID = "roleMemberId";
        static final String TYPE_CODE = "typeCode";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "delegateMember";
        static final String TYPE_NAME = "DelegateMemberType";

        Constants() {
        }
    }
}

