/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.identity;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.kuali.rice.kim.api.identity.name.EntityName;
import org.kuali.rice.kim.api.identity.name.EntityNameContract;
import org.kuali.rice.kim.api.identity.principal.EntityNamePrincipalName;
import org.kuali.rice.kim.impl.identity.IdentityServiceDao;
import org.kuali.rice.kim.impl.identity.name.EntityNameBo;

public class IdentityServiceDaoJpa
implements IdentityServiceDao {
    private static final int PARTITION_SIZE = 500;
    private EntityManager entityManager;

    @Override
    public Map<String, EntityNamePrincipalName> getDefaultNamesByPrincipalIds(List<String> principalIds) {
        HashMap<String, EntityNamePrincipalName> results = new HashMap<String, EntityNamePrincipalName>();
        List partitionedPrincipalIds = Lists.partition(principalIds, (int)500);
        for (List partition : partitionedPrincipalIds) {
            List names = this.getEntityManager().createNamedQuery("EntityNameBo.findDefaultNamesForPrincipalIds", NameHolder.class).setParameter("principalIds", (Object)partition).getResultList();
            for (NameHolder name : names) {
                EntityNamePrincipalName.Builder nameBuilder = EntityNamePrincipalName.Builder.create();
                EntityNameBo entityName = name.getEntityName();
                entityName.setSuppressName(name.isSuppressName());
                nameBuilder.setDefaultName(EntityName.Builder.create((EntityNameContract)entityName));
                nameBuilder.setPrincipalName(name.getPrincipalName());
                results.put(name.getPrincipalId(), nameBuilder.build());
            }
        }
        return results;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public static class NameHolder {
        private EntityNameBo entityName;
        private String principalId;
        private String principalName;
        private boolean suppressName;

        public NameHolder() {
        }

        public NameHolder(EntityNameBo entityName, String principalId, String principalName, boolean suppressName) {
            this.entityName = entityName;
            this.principalId = principalId;
            this.principalName = principalName;
            this.suppressName = suppressName;
        }

        public EntityNameBo getEntityName() {
            return this.entityName;
        }

        public void setEntityName(EntityNameBo entityName) {
            this.entityName = entityName;
        }

        public String getPrincipalId() {
            return this.principalId;
        }

        public void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        public String getPrincipalName() {
            return this.principalName;
        }

        public void setPrincipalName(String principalName) {
            this.principalName = principalName;
        }

        public boolean isSuppressName() {
            return this.suppressName;
        }

        public void setSuppressName(boolean suppressName) {
            this.suppressName = suppressName;
        }
    }
}

