/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.impl.identity.citizenship;

import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.kuali.rice.kim.api.identity.CodedAttribute;
import org.kuali.rice.kim.framework.identity.citizenship.EntityCitizenshipStatusEbo;
import org.kuali.rice.kim.impl.identity.CodedAttributeBo;

@AttributeOverrides({ @AttributeOverride(name = "code", column = @Column(name = "CTZNSHP_STAT_CD")) })
@Entity
@Table(name = "KRIM_CTZNSHP_STAT_T")
public class EntityCitizenshipStatusBo extends CodedAttributeBo implements EntityCitizenshipStatusEbo {

    private static final long serialVersionUID = 8402224265524503990L;

    public static EntityCitizenshipStatusBo from(CodedAttribute immutable) {
        return CodedAttributeBo.from(EntityCitizenshipStatusBo.class, immutable);
    }
}
