/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.datadictionary;

import java.io.Serializable;
import java.util.List;

import org.kuali.rice.kns.document.authorization.DocumentAuthorizer;
import org.kuali.rice.kns.document.authorization.DocumentPresentationController;
import org.kuali.rice.kns.rule.PromptBeforeValidation;
import org.kuali.rice.kns.web.derivedvaluesetter.DerivedValuesSetter;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntry;
import org.kuali.rice.krad.datadictionary.ReferenceDefinition;
import org.kuali.rice.krad.datadictionary.WorkflowAttributes;
import org.kuali.rice.krad.datadictionary.WorkflowProperties;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.keyvalues.KeyValuesFinder;
import org.kuali.rice.krad.rules.rule.BusinessRule;

/**
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 * @deprecated Use {@link org.kuali.rice.krad.datadictionary.DocumentEntry}.
 */
@Deprecated
public interface KNSDocumentEntry extends DataDictionaryEntry, Serializable {

    public Class<? extends Document> getDocumentClass();

    public void setDocumentClass(Class<? extends Document> documentClass);

    public Class<? extends Document> getBaseDocumentClass();

    public void setBaseDocumentClass(Class<? extends Document> baseDocumentClass);

    public Class<? extends BusinessRule> getBusinessRulesClass();

    public void setBusinessRulesClass(Class<? extends BusinessRule> businessRulesClass);

    public String getDocumentTypeName();

    public void setDocumentTypeName(String documentTypeName);

    public boolean getDisplayTopicFieldInNotes();

    public void setDisplayTopicFieldInNotes(boolean displayTopicFieldInNotes);

    public boolean getUsePessimisticLocking();

    public void setUsePessimisticLocking(boolean usePessimisticLocking);

    public boolean getUseWorkflowPessimisticLocking();

    public void setUseWorkflowPessimisticLocking(boolean useWorkflowPessimisticLocking);

    public Class<? extends KeyValuesFinder> getAttachmentTypesValuesFinderClass();

    public void setAttachmentTypesValuesFinderClass(Class<? extends KeyValuesFinder> attachmentTypesValuesFinderClass);

    public boolean getAllowsCopy();

    public void setAllowsCopy(boolean allowsCopy);

    public boolean getAllowsNoteAttachments();

    public void setAllowsNoteAttachments(boolean allowsNoteAttachments);

    public boolean getAllowsNoteFYI();

    public void setAllowsNoteFYI(boolean allowsNoteFYI);

    public WorkflowProperties getWorkflowProperties();

    public void setWorkflowProperties(WorkflowProperties workflowProperties);

    public WorkflowAttributes getWorkflowAttributes();

    public void setWorkflowAttributes(WorkflowAttributes workflowAttributes);

    public List<ReferenceDefinition> getDefaultExistenceChecks();

    public void setDefaultExistenceChecks(List<ReferenceDefinition> defaultExistenceChecks);

    public boolean isEncryptDocumentDataInPersistentSessionStorage();

    public void setEncryptDocumentDataInPersistentSessionStorage(
                boolean encryptDocumentDataInPersistentSessionStorage);

    List<HeaderNavigation> getHeaderNavigationList();

    List<String> getWebScriptFiles();

    Class<? extends PromptBeforeValidation> getPromptBeforeValidationClass();

    void setPromptBeforeValidationClass(Class<? extends PromptBeforeValidation> preRulesCheckClass);

    void setWebScriptFiles(List<String> webScriptFiles);

    void setHeaderNavigationList(List<HeaderNavigation> headerNavigationList);

    boolean isSessionDocument();

    void setSessionDocument(boolean sessionDocument);

    Class<? extends DerivedValuesSetter> getDerivedValuesSetterClass();

    void setDerivedValuesSetterClass(Class<? extends DerivedValuesSetter> derivedValuesSetter);

    public Class<? extends DocumentAuthorizer> getDocumentAuthorizerClass();

    public Class<? extends DocumentPresentationController> getDocumentPresentationControllerClass();


}
