/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.core.framework.persistence.ojb;

import javax.transaction.TransactionManager;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springmodules.orm.ojb.support.LocalOjbConfigurer;

/**
 * Utility bean that sets the JTA TransactionManager on the WorkflowTransactionManagerFactory, the
 * OJB TransactionManagerFactory implementation that makes this available from Workflow core.
 * @see TransactionManagerFactory
 * @see org.apache.ojb.broker.transaction.tm.TransactionManagerFactory
 */
@Deprecated
public class JtaOjbConfigurer extends LocalOjbConfigurer implements InitializingBean, DisposableBean {
    private static final Logger LOG = LogManager.getLogger(JtaOjbConfigurer.class);

	private TransactionManager transactionManager;

	@Override
	public void setBeanFactory(BeanFactory beanFactory) {
		super.setBeanFactory(beanFactory);
		RiceDataSourceConnectionFactory.addBeanFactory(beanFactory);
	}

	@Override
    public void afterPropertiesSet() {
        LOG.debug("Setting OJB WorkflowTransactionManagerFactory transaction manager to: " + this.transactionManager);
        TransactionManagerFactory.setTransactionManager(this.transactionManager);
	}

	@Override
    public void destroy() {
	    this.transactionManager = null;
	}

	public void setTransactionManager(TransactionManager transactionManager) {
		this.transactionManager = transactionManager;
	}
}
