/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.datadictionary.validation.charlevel;

import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.kuali.rice.krad.datadictionary.exporter.ExportMap;
import org.kuali.rice.krad.datadictionary.validation.CharacterLevelValidationPattern;

/**
 * @deprecated Use {@link org.kuali.rice.krad.datadictionary.validation.constraint.ConfigurationBasedRegexPatternConstraint}.
 */
@Deprecated
public class RegexValidationPattern extends CharacterLevelValidationPattern {

    private static final long serialVersionUID = -5642894236634278352L;
    private static final Logger LOG=LogManager.getLogger(RegexValidationPattern.class);
    /**
     * Regular expression, e.g. "[a-zA-Z0-9]"
     */
    private String pattern;

    private String validationErrorMessageKey;
    /**
     * This exports a representation of this instance by an ExportMap.
     * 
     * @see org.kuali.rice.krad.datadictionary.validation.CharacterLevelValidationPattern#extendExportMap(org.kuali.rice.krad.datadictionary.exporter.ExportMap)
     */
    @Override
	public void extendExportMap(ExportMap exportMap) {
        if (LOG.isTraceEnabled()) {
            String message=String.format("ENTRY %s",
                    (exportMap==null)?"null":exportMap.toString());
            LOG.trace(message);
        }
        
        // Set element value
        exportMap.set("type", "regex");
        // Set attribute (of the above element) value
        exportMap.set("pattern", getPattern());

        if (LOG.isTraceEnabled()) {
            String message=String.format("EXIT %s",
                    (exportMap==null)?"null":exportMap.toString());
            LOG.trace(message);
        }
        
     }

    /**
     * This returns an instance of this class as string.
     * 
     * @see org.kuali.rice.krad.datadictionary.validation.ValidationPattern#getPatternXml()
     */
    public String getPatternXml() {
        if (LOG.isTraceEnabled()) {
            String message=String.format("ENTRY");
            LOG.trace(message);
        }
        
        StringBuffer xml = new StringBuffer("<regex ");
        xml.append(pattern);
        xml.append("/>");

        if (LOG.isTraceEnabled()) {
            String message=String.format("EXIT %s", xml.toString());
            LOG.trace(message);
        }
        
        return xml.toString();
    }

    /**
     * This returns the specified regular expression defined in the data dictionary
     * entry for validating the value of an attribute.
     * 
     * @see org.kuali.rice.krad.datadictionary.validation.ValidationPattern#getRegexString()
     */
    @Override
	protected String getRegexString() {
        if (LOG.isTraceEnabled()) {
            String message=String.format("ENTRY %s",
                    (pattern==null)?"null":pattern.toString());
            LOG.trace(message);
        }
        
        if (StringUtils.isEmpty(pattern)) {
            throw new IllegalStateException(this.getClass().getName()+".pattern is empty");
        }

        if (LOG.isTraceEnabled()) {
            String message=String.format("EXIT");
            LOG.trace(message);
        }
        
        return pattern;
    }

    /**
     * @return the pattern
     */
    public final String getPattern() {
        return this.pattern;
    }

    /**
     * @param pattern the pattern to set
     */
    public final void setPattern(String pattern) {
        this.pattern = pattern;
    }

	/**
	 * @return the validationErrorMessageKey
	 */
    @Override
	public String getValidationErrorMessageKey() {
		return this.validationErrorMessageKey;
	}

	/**
	 * @param validationErrorMessageKey a message key from the application's message resource bundle signifying the error message
	 * to display if some validation does not match this pattern
	 */
	public void setValidationErrorMessageKey(String validationErrorMessageKey) {
		this.validationErrorMessageKey = validationErrorMessageKey;
	}

	/**
	 * @see org.kuali.rice.krad.datadictionary.validation.ValidationPattern#completeValidation()
	 */
	@Override
	public void completeValidation() {
		super.completeValidation();
		if (StringUtils.isBlank(validationErrorMessageKey)) {
			throw new ValidationPatternException("Regex Validation Patterns must have a validation error message key defined");
		}
	}
}
