/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.dao.proxy;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.bo.ModuleConfiguration;
import org.kuali.rice.krad.dao.LookupDao;
import org.kuali.rice.krad.dao.impl.LookupDaoOjb;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiModuleService;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.util.LegacyUtils;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@Transactional
public class LookupDaoProxy implements LookupDao {
    
	private LookupDao lookupDaoOjb;
    private static KualiModuleService kualiModuleService;
    private static Map<String, LookupDao> lookupDaoValues = Collections.synchronizedMap(new HashMap<String, LookupDao>());
	
	public void setLookupDaoOjb(LookupDao lookupDaoOjb) {
		this.lookupDaoOjb = lookupDaoOjb;
	}
	
    private LookupDao getDao(Class clazz) {
        ModuleService moduleService = getKualiModuleService().getResponsibleModuleService(clazz);
        if (moduleService != null) {
            ModuleConfiguration moduleConfig = moduleService.getModuleConfiguration();
            String dataSourceName = "";
            if (moduleConfig != null) {
                dataSourceName = moduleConfig.getDataSourceName();
            }

            if (StringUtils.isNotEmpty(dataSourceName)) {
                if (lookupDaoValues.get(dataSourceName) != null) {
                    return lookupDaoValues.get(dataSourceName);
                } else {
                    LookupDaoOjb classSpecificLookupDaoOjb = new LookupDaoOjb();
                    classSpecificLookupDaoOjb.setJcdAlias(dataSourceName);
                    classSpecificLookupDaoOjb.setPersistenceStructureService(
                            KNSServiceLocator.getPersistenceStructureService());
                    classSpecificLookupDaoOjb.setDateTimeService(CoreApiServiceLocator.getDateTimeService());
                    classSpecificLookupDaoOjb.setDataDictionaryService(
                            KRADServiceLocatorWeb.getDataDictionaryService());
                    lookupDaoValues.put(dataSourceName, classSpecificLookupDaoOjb);
                    return classSpecificLookupDaoOjb;
                }

            }
        }
        return lookupDaoOjb;
    }
    
	/**
	 * @see org.kuali.rice.krad.dao.LookupDao#createCriteria(java.lang.Object, java.lang.String, java.lang.String, java.lang.Object)
	 */
	@Override
    public boolean createCriteria(Object example, String searchValue, String propertyName, Object criteria) {
		return getDao(example.getClass()).createCriteria(example, searchValue, propertyName, criteria);
	}

	/**
	 * @see org.kuali.rice.krad.dao.LookupDao#createCriteria(java.lang.Object, java.lang.String, java.lang.String, boolean, java.lang.Object)
	 */
	@Override
    public boolean createCriteria(Object example, String searchValue, String propertyName, boolean caseInsensitive, boolean treatWildcardsAndOperatorsAsLiteral, Object criteria) {
		return getDao(example.getClass()).createCriteria(example, searchValue, propertyName, caseInsensitive,
                treatWildcardsAndOperatorsAsLiteral, criteria);
	}

    /**
     * Since 2.3
     * This version of findCollectionBySearchHelper is needed for version compatibility.   It allows executeSearch
     * to behave the same way as it did prior to 2.3. In the LookupDao, the value for searchResultsLimit will be
     * retrieved from the KNS version of LookupUtils in the LookupDao.
     *
     * @see org.kuali.rice.krad.dao.LookupDao#findCollectionBySearchHelper(java.lang.Class, java.util.Map, boolean,
     *      boolean)
     */
    @Override
    public Collection findCollectionBySearchHelper(Class businessObjectClass, Map formProps, boolean unbounded,
                                                   boolean usePrimaryKeyValuesOnly) {
        return getDao(businessObjectClass).findCollectionBySearchHelper(businessObjectClass, formProps, unbounded,
                usePrimaryKeyValuesOnly);
    }

    /**
     * @see org.kuali.rice.krad.dao.LookupDao#findCollectionBySearchHelper(java.lang.Class, java.util.Map, boolean,
     *      boolean, Integer)
     */
    @Override
    public Collection findCollectionBySearchHelper(Class businessObjectClass, Map formProps, boolean unbounded,
                                                   boolean usePrimaryKeyValuesOnly, Integer searchResultsLimit) {
        return getDao(businessObjectClass).findCollectionBySearchHelper(businessObjectClass, formProps, unbounded,
                usePrimaryKeyValuesOnly, searchResultsLimit);
    }

	/**
	 * @see org.kuali.rice.krad.dao.LookupDao#findCountByMap(java.lang.Object, java.util.Map)
	 */
	@Override
    public Long findCountByMap(Object example, Map formProps) {
		return getDao(example.getClass()).findCountByMap(example, formProps);
	}

    @Override
    public <T extends Object> T findObjectByMap(Class<T> type, Map<String, String> formProps) {
        return getDao(type).findObjectByMap(type, formProps);
    }

	private static KualiModuleService getKualiModuleService() {
        if (kualiModuleService == null) {
            kualiModuleService = KRADServiceLocatorWeb.getKualiModuleService();
        }
        return kualiModuleService;
    }
}
