/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.question;

import java.util.ArrayList;

/**
 * This class is a base class to implement questions types.
 * 
 * 
 *         "confirmation questions") rather than specific questions.
 *
 * @deprecated Only used in KNS classes, use KRAD.
 */
@Deprecated
public class QuestionBase implements Question {
    String question;
    ArrayList buttons;

    /**
     * default constructor
     * 
     * @param question the question to assign to this question prompt
     * @param buttons the buttons associated with it
     */
    public QuestionBase(String question, ArrayList buttons) {
        this.question = question;
        this.buttons = buttons;
    }

    /**
     * returns the index associated with a specified button
     * 
     * @param btnText the text of the button
     * @return the index of this button
     */
    @Override
    public String getButtonIndex(String btnText) {
        return "" + buttons.indexOf(btnText);
    }

    /**
     * @return Returns the buttons.
     */
    @Override
    public ArrayList getButtons() {
        return buttons;
    }

    /**
     * @param buttons The buttons to set.
     */
    @Override
    public void setButtons(ArrayList buttons) {
        this.buttons = buttons;
    }

    /**
     * @return Returns the question.
     */
    @Override
    public String getQuestion() {
        return question;
    }

    /**
     * @param question The question to set.
     */
    @Override
    public void setQuestion(String question) {
        this.question = question;
    }
}
