/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.document.authorization;

import org.kuali.rice.kns.inquiry.InquiryRestrictions;
import org.kuali.rice.kns.web.ui.Field;

import java.util.HashSet;
import java.util.Set;

/**
 * @deprecated Only used in KNS classes, use KRAD.
 */
@Deprecated
public class InquiryOrMaintenanceDocumentRestrictionsBase extends
		BusinessObjectRestrictionsBase implements InquiryOrMaintenanceDocumentRestrictions, InquiryRestrictions {
	private Set<String> hiddenFields;
	private Set<String> hiddenSectionIds;

	@Override
    public void addHiddenField(String fieldName) {
		hiddenFields.add(fieldName);
	}

	@Override
    public void addHiddenSectionId(String sectionId) {
		hiddenSectionIds.add(sectionId);
	}

	@Override
	public FieldRestriction getFieldRestriction(String fieldName) {
		FieldRestriction fieldRestriction = super
				.getFieldRestriction(fieldName);
		if (isHiddenField(fieldName)) {
			fieldRestriction = new FieldRestriction(fieldName, Field.HIDDEN);
		}
		return fieldRestriction;			
	}

	/**
	 * @see org.kuali.rice.krad.authorization.BusinessObjectRestrictionsBase#hasRestriction(java.lang.String)
	 */
	@Override
	public boolean hasRestriction(String fieldName) {
		return super.hasRestriction(fieldName) || isHiddenField(fieldName);
	}
	
	/**
	 * @see org.kuali.rice.krad.authorization.BusinessObjectRestrictionsBase#hasAnyFieldRestrictions()
	 */
	@Override
	public boolean hasAnyFieldRestrictions() {
		return super.hasAnyFieldRestrictions() || !hiddenFields.isEmpty();
	}

	@Override
	public void clearAllRestrictions() {
		super.clearAllRestrictions();
		hiddenFields = new HashSet<String>();
		hiddenSectionIds = new HashSet<String>();
	}

	/**
	 * @see org.kuali.rice.krad.authorization.InquiryOrMaintenanceDocumentRestrictions#isHiddenSectionId(java.lang.String)
	 */
	@Override
    public boolean isHiddenSectionId(String sectionId) {
		return hiddenSectionIds.contains(sectionId);
	}

	protected boolean isHiddenField(String fieldName) {
		String normalizedFieldName = normalizeFieldName(fieldName);
		return hiddenFields.contains(normalizedFieldName);
	}
}
