/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.bo;

import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.ClassUtils;

import java.lang.reflect.Field;

/**
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * @deprecated use new KRAD Data framework {@link org.kuali.rice.krad.data.DataObjectService}
 */
@Deprecated
public abstract class BusinessObjectBase implements BusinessObject {

    /**
     * Default constructor. Required to do some of the voodoo involved in letting the DataDictionary validate attributeNames for a
     * given BusinessObject subclass.
     */
    public BusinessObjectBase() {
    }

    @Override
	public String toString() {
        class BusinessObjectToStringBuilder extends ReflectionToStringBuilder {

            private BusinessObjectToStringBuilder(Object object) {
                super(object);
            }

            @Override
            public boolean accept(Field field) {
                // ignore printing out byte arrays in toString methods
                if (byte[].class.isAssignableFrom(field.getType())) {
                  return false;
                }
                return String.class.isAssignableFrom(field.getType())
                        || ClassUtils.isPrimitiveOrWrapper(field.getType());
            }

        }

        return new BusinessObjectToStringBuilder(this).toString();
    }

}
