/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.comparator;

import org.kuali.rice.core.web.format.DateFormatter;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;

public class TemporalValueComparator implements Comparator, Serializable {
    private static final TemporalValueComparator theInstance = new TemporalValueComparator();
    
    public TemporalValueComparator() {
    }
    
    public static TemporalValueComparator getInstance() {
        return theInstance;
    }
    
    @Override
    public int compare(Object o1, Object o2) {

        // null guard. non-null value is greater. equal if both are null
        if (null == o1 || null == o2) {
            return null == o1 && null == o2 ? 0 : null == o1 ? -1 : 1;
        }

        String s1 = (String) o1;
        String s2 = (String) o2;

        DateFormatter f1 = new DateFormatter();

        Date d1 = (Date) f1.convertFromPresentationFormat(s1);
        Date d2 = (Date) f1.convertFromPresentationFormat(s2);
        
        if (null == d1 || null == d2) {
            return null == d1 && null == d2 ? 0 : null == d1 ? -1 : 1;
        }

        return d1.equals(d2) ? 0 : d1.before(d2) ? -1 : 1;
    }
}
