/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.exception;

import org.kuali.rice.kew.api.WorkflowRuntimeException;

/**
 * Exception thrown when an invalid export is attempted.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ExportNotSupportedException extends WorkflowRuntimeException {

	private static final long serialVersionUID = 1450235230768995894L;

	public ExportNotSupportedException(String message) {
        super(message);
    }

    public ExportNotSupportedException() {
        super();
    }

    public ExportNotSupportedException(String message, Throwable cause) {
        super(message, cause);
    }

    public ExportNotSupportedException(Throwable cause) {
        super(cause);
    }

}
