/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.data.metadata.impl;

import org.kuali.rice.krad.data.metadata.DataObjectAttributeRelationship;

/**
* {@inheritDoc}
*/
public class DataObjectAttributeRelationshipImpl implements DataObjectAttributeRelationship {
	private static final long serialVersionUID = 838360378126210069L;

	protected String parentAttributeName;
	protected String childAttributeName;

	public DataObjectAttributeRelationshipImpl() {
	}

    /**
    * Gets results where the actual rows are requested.
    *
    * @param queryClass the type of the results to return.
    * @param criteria the criteria to use to get the results.
    * @param ojbCriteria the implementation-specific criteria.
    * @param flag the indicator to whether the row count is requested in the results.
    * @return results where the actual rows are requested.
    */
	public DataObjectAttributeRelationshipImpl(String parentAttributeName, String childAttributeName) {
		super();
		this.parentAttributeName = parentAttributeName;
		this.childAttributeName = childAttributeName;
	}

    /**
    * {@inheritDoc}
    */
	@Override
	public String getParentAttributeName() {
		return parentAttributeName;
	}

    /**
    * Sets the parent attribute name.
    *
    * @param parentAttributeName parent attribute name
    */
	public void setParentAttributeName(String parentAttributeName) {
		this.parentAttributeName = parentAttributeName;
	}

    /**
    * {@inheritDoc}
    */
	@Override
	public String getChildAttributeName() {
		return childAttributeName;
	}

    /**
    * Sets the child attribute name.
    *
    * @param childAttributeName child attribute name
    */
    public void setChildAttributeName(String childAttributeName) {
		this.childAttributeName = childAttributeName;
	}

    /**
    * {@inheritDoc}
    */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[parentAttributeName=").append(parentAttributeName).append(", childAttributeName=")
				.append(childAttributeName).append("]");
		return builder.toString();
	}
}
