/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.platform;

import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.data.platform.MaxValueIncrementerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;

public class MaxValueIncrementerFactoryBean
implements FactoryBean<DataFieldMaxValueIncrementer>,
InitializingBean {
    private DataSource dataSource;
    private String incrementerName;

    public DataFieldMaxValueIncrementer getObject() throws Exception {
        return MaxValueIncrementerFactory.getIncrementer(this.dataSource, this.incrementerName);
    }

    public Class<DataFieldMaxValueIncrementer> getObjectType() {
        return DataFieldMaxValueIncrementer.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.dataSource == null) {
            throw new IllegalStateException("Property 'dataSource' is required");
        }
        if (StringUtils.isBlank((String)this.incrementerName)) {
            throw new IllegalStateException("Property 'incrementerName' is required");
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getIncrementerName() {
        return this.incrementerName;
    }

    public void setIncrementerName(String incrementerName) {
        this.incrementerName = incrementerName;
    }
}

