/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.data.metadata;

import java.util.List;

/**
* Collection metadata
*
* <p>
* Represents the metadata for a collection within a data object.
* </p>
*
* @author Kuali Rice Team (rice.collab@kuali.org)
*/
public interface DataObjectCollection extends MetadataChild {

    /**
    * Gets name of single object in collection
    *
    * <p>
    * The elementLabel defines the name to be used for a single object within the collection. For example:
    * "Address" may be the name of one object within the "Addresses" collection.
    * </p>
    *
    * return name of single object in collection
    */
	String getElementLabel();

    /**
    * Gets the minimum number of items which may be in the collection.
    *
    * <p>
    * This is an optional attribute and may not be set by the metadata provider.
    * </p>
    *
    * @return The minimum number of items which must be in this collection or <b>null</b> if unset.
    */
	Long getMinItems();

    /**
    * The maximum number of items which may be in the collection.
    *
    * <p>
    * This is an optional attribute and may not be set by the metadata provider.
    * </p>
    *
    * @return The maximum number of items which may be in this collection or <b>null</b> if unset.
    */
	Long getMaxItems();

    /**
    * Gets the default ordering of a collection.
    *
    * <p>
    * The default ordering of collection items as specified by the metadata provider.
    * </p>
    *
    * @return The list of fields in order by which to sort, or an empty list if none specified.
    */
	List<DataObjectCollectionSortAttribute> getDefaultOrdering();

    /**
    * Determines whether a linked objected is used.
    *
    * <p>
    * Whether the referenced collection uses a linking object in the underlying implementation. (In case that is
    * somehow important to using code.).
    * </p>
    *
    * @return whether a linked object is used
    */
	boolean isIndirectCollection();
}
