/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.data.platform;

/**
 * A runtime exception which indicates that an unsupported database platform was encountered.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class UnsupportedDatabasePlatformException extends RuntimeException {

    /**
     * Creates an unsupported database platform exception.
     */
    public UnsupportedDatabasePlatformException() {}

    /**
     * Creates an unsupported database platform exception.
     *
     * @param platformInfo the platform that was in exception.
     */
    public UnsupportedDatabasePlatformException(DatabasePlatformInfo platformInfo) {
        super("Unsupported database platform " + platformInfo.toString());
    }

    /**
     * Creates an unsupported database platform exception.
     *
     * @param message the message to throw.
     */
    public UnsupportedDatabasePlatformException(String message) {
        super(message);
    }

    /**
     * Creates an unsupported database platform exception.
     *
     * @param message the message to throw.
     * @param cause the underlying stacktrace.
     */
    public UnsupportedDatabasePlatformException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Creates an unsupported database platform exception.
     *
     * @param cause the underlying stacktrace.
     */
    public UnsupportedDatabasePlatformException(Throwable cause) {
        super(cause);
    }
}
