/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.jpa;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.criteria.AndPredicate;
import org.kuali.rice.core.api.criteria.CompositePredicate;
import org.kuali.rice.core.api.criteria.CriteriaValue;
import org.kuali.rice.core.api.criteria.EqualIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.EqualPredicate;
import org.kuali.rice.core.api.criteria.ExistsSubQueryPredicate;
import org.kuali.rice.core.api.criteria.GreaterThanOrEqualPredicate;
import org.kuali.rice.core.api.criteria.GreaterThanPredicate;
import org.kuali.rice.core.api.criteria.InIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.InPredicate;
import org.kuali.rice.core.api.criteria.LessThanOrEqualPredicate;
import org.kuali.rice.core.api.criteria.LessThanPredicate;
import org.kuali.rice.core.api.criteria.LikeIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.LikePredicate;
import org.kuali.rice.core.api.criteria.MultiValuedPredicate;
import org.kuali.rice.core.api.criteria.NotEqualIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.NotEqualPredicate;
import org.kuali.rice.core.api.criteria.NotInIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.NotInPredicate;
import org.kuali.rice.core.api.criteria.NotLikeIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.NotLikePredicate;
import org.kuali.rice.core.api.criteria.NotNullPredicate;
import org.kuali.rice.core.api.criteria.NullPredicate;
import org.kuali.rice.core.api.criteria.OrPredicate;
import org.kuali.rice.core.api.criteria.OrderByField;
import org.kuali.rice.core.api.criteria.OrderDirection;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.PropertyPathPredicate;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.SingleValuedPredicate;
import org.kuali.rice.core.api.criteria.SubQueryPredicate;
import org.kuali.rice.krad.data.jpa.QueryTranslator;

abstract class QueryTranslatorBase<C, Q, QC>
implements QueryTranslator<C, Q, QC> {
    public static final int MULTI_VALUE_CHUNK_SIZE = 1000;

    QueryTranslatorBase() {
    }

    protected abstract C createCriteria(Class<?> var1);

    protected abstract C createCriteriaForCount(Class<?> var1);

    protected abstract C createCriteriaForSubQuery(Class<?> var1, C var2);

    protected abstract C createInnerCriteria(C var1);

    protected abstract String genUpperFunc(String var1);

    protected abstract void addNotNull(C var1, String var2);

    protected abstract void addIsNull(C var1, String var2);

    protected abstract void addEqualTo(C var1, String var2, Object var3);

    protected abstract void addGreaterOrEqualTo(C var1, String var2, Object var3);

    protected abstract void addGreaterThan(C var1, String var2, Object var3);

    protected abstract void addLessOrEqualTo(C var1, String var2, Object var3);

    protected abstract void addLessThan(C var1, String var2, Object var3);

    protected abstract void addLike(C var1, String var2, Object var3);

    protected abstract void addNotEqualTo(C var1, String var2, Object var3);

    protected abstract void addNotLike(C var1, String var2, Object var3);

    protected abstract void addNotLikeIgnoreCase(C var1, String var2, String var3);

    protected abstract void addIn(C var1, String var2, Collection<?> var3);

    protected abstract void addNotIn(C var1, String var2, Collection<?> var3);

    protected abstract void addAnd(C var1, C var2);

    protected abstract void addOr(C var1, C var2);

    protected abstract void addExistsSubquery(C var1, String var2, Predicate var3);

    protected abstract void addOrderBy(C var1, String var2, boolean var3);

    protected void addEqualToIgnoreCase(C criteria, String propertyPath, String value) {
        this.addEqualTo(criteria, this.genUpperFunc(propertyPath), value.toUpperCase());
    }

    protected void addNotEqualToIgnoreCase(C criteria, String propertyPath, String value) {
        this.addNotEqualTo(criteria, this.genUpperFunc(propertyPath), value.toUpperCase());
    }

    protected void addLikeIgnoreCase(C criteria, String propertyPath, String value) {
        this.addLike(criteria, this.genUpperFunc(propertyPath), value.toUpperCase());
    }

    @Override
    public C translateCriteria(Class<?> queryClazz, QueryByCriteria qbc) {
        C parent = this.createCriteria(queryClazz);
        if (qbc.getPredicate() != null) {
            this.addPredicate(qbc.getPredicate(), parent);
        }
        if (!qbc.getOrderByFields().isEmpty()) {
            this.addOrderBy(qbc.getOrderByFields(), parent);
        }
        return parent;
    }

    @Override
    public C translateCriteriaForCount(Class<?> queryClazz, QueryByCriteria qbc) {
        C parent = this.createCriteriaForCount(queryClazz);
        if (qbc.getPredicate() != null) {
            this.addPredicate(qbc.getPredicate(), parent);
        }
        return parent;
    }

    protected void addOrderBy(List<OrderByField> orderByFields, C parent) {
        for (OrderByField field : orderByFields) {
            this.addOrderBy(parent, field.getFieldName(), OrderDirection.ASCENDING.equals((Object)field.getOrderDirection()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addPredicate(Predicate p, C parent) {
        if (p instanceof PropertyPathPredicate) {
            String pp = ((PropertyPathPredicate)p).getPropertyPath();
            if (p instanceof NotNullPredicate) {
                this.addNotNull(parent, pp);
                return;
            } else if (p instanceof NullPredicate) {
                this.addIsNull(parent, pp);
                return;
            } else if (p instanceof SingleValuedPredicate) {
                this.addSingleValuePredicate((SingleValuedPredicate)p, parent);
                return;
            } else {
                if (!(p instanceof MultiValuedPredicate)) throw new UnsupportedPredicateException(p);
                this.addMultiValuePredicate((MultiValuedPredicate)p, parent);
            }
            return;
        } else if (p instanceof CompositePredicate) {
            this.addCompositePredicate((CompositePredicate)p, parent);
            return;
        } else {
            if (!(p instanceof SubQueryPredicate)) throw new UnsupportedPredicateException(p);
            this.addSubQueryPredicate((SubQueryPredicate)p, parent);
        }
    }

    protected void addSingleValuePredicate(SingleValuedPredicate p, C parent) {
        Object value = QueryTranslatorBase.getVal(p.getValue());
        String pp = p.getPropertyPath();
        if (p instanceof EqualPredicate) {
            this.addEqualTo(parent, pp, value);
        } else if (p instanceof EqualIgnoreCasePredicate) {
            this.addEqualToIgnoreCase(parent, pp, (String)value);
        } else if (p instanceof GreaterThanOrEqualPredicate) {
            this.addGreaterOrEqualTo(parent, pp, value);
        } else if (p instanceof GreaterThanPredicate) {
            this.addGreaterThan(parent, pp, value);
        } else if (p instanceof LessThanOrEqualPredicate) {
            this.addLessOrEqualTo(parent, pp, value);
        } else if (p instanceof LessThanPredicate) {
            this.addLessThan(parent, pp, value);
        } else if (p instanceof LikePredicate) {
            this.addLike(parent, pp, value);
        } else if (p instanceof LikeIgnoreCasePredicate) {
            this.addLikeIgnoreCase(parent, pp, (String)value);
        } else if (p instanceof NotEqualPredicate) {
            this.addNotEqualTo(parent, pp, value);
        } else if (p instanceof NotEqualIgnoreCasePredicate) {
            this.addNotEqualToIgnoreCase(parent, pp, (String)value);
        } else if (p instanceof NotLikeIgnoreCasePredicate) {
            this.addNotLikeIgnoreCase(parent, pp, (String)value);
        } else if (p instanceof NotLikePredicate) {
            this.addNotLike(parent, pp, value);
        } else {
            throw new UnsupportedPredicateException((Predicate)p);
        }
    }

    protected void addMultiValuePredicate(MultiValuedPredicate p, C parent) {
        if (p.getValues().size() > 1000) {
            this.splitMultiValuePredicate(p, parent);
        } else {
            String pp = p.getPropertyPath();
            if (p instanceof InPredicate) {
                Set<?> predicateValues = QueryTranslatorBase.getVals(p.getValues());
                this.addIn(parent, pp, predicateValues);
            } else if (p instanceof InIgnoreCasePredicate) {
                Set<String> predicateValues = QueryTranslatorBase.toUpper(QueryTranslatorBase.getValsUnsafe(((InIgnoreCasePredicate)p).getValues()));
                this.addIn(parent, this.genUpperFunc(pp), predicateValues);
            } else if (p instanceof NotInPredicate) {
                Set<?> predicateValues = QueryTranslatorBase.getVals(p.getValues());
                this.addNotIn(parent, pp, predicateValues);
            } else if (p instanceof NotInIgnoreCasePredicate) {
                Set<String> predicateValues = QueryTranslatorBase.toUpper(QueryTranslatorBase.getValsUnsafe(((NotInIgnoreCasePredicate)p).getValues()));
                this.addNotIn(parent, this.genUpperFunc(pp), predicateValues);
            } else {
                throw new UnsupportedPredicateException((Predicate)p);
            }
        }
    }

    private void splitMultiValuePredicate(MultiValuedPredicate p, C parent) {
        String pp = p.getPropertyPath();
        int chunkCount = (int)Math.ceil((double)p.getValues().size() / 1000.0);
        Predicate[] multiValuePredicateChunks = new Predicate[chunkCount];
        Object[] values = p.getValues().toArray();
        int start = 0;
        for (int i = 0; i < chunkCount; ++i) {
            Object[] valueChunk = Arrays.copyOfRange(values, start, start + 1000);
            if (p instanceof InPredicate) {
                multiValuePredicateChunks[i] = PredicateFactory.in((String)pp, (Object[])valueChunk);
            } else if (p instanceof InIgnoreCasePredicate) {
                multiValuePredicateChunks[i] = PredicateFactory.inIgnoreCase((String)pp, (CharSequence[])((CharSequence[])valueChunk));
            } else if (p instanceof NotInPredicate) {
                multiValuePredicateChunks[i] = PredicateFactory.notIn((String)pp, (Object[])valueChunk);
            } else if (p instanceof NotInIgnoreCasePredicate) {
                multiValuePredicateChunks[i] = PredicateFactory.notInIgnoreCase((String)pp, (CharSequence[])((CharSequence[])valueChunk));
            } else {
                throw new UnsupportedPredicateException((Predicate)p);
            }
            start += 1000;
        }
        this.addPredicate(PredicateFactory.or((Predicate[])multiValuePredicateChunks), parent);
    }

    protected void addCompositePredicate(CompositePredicate p, C parent) {
        for (Predicate ip : p.getPredicates()) {
            C inner = this.createInnerCriteria(parent);
            this.addPredicate(ip, inner);
            if (p instanceof AndPredicate) {
                this.addAnd(parent, inner);
                continue;
            }
            if (p instanceof OrPredicate) {
                this.addOr(parent, inner);
                continue;
            }
            throw new UnsupportedPredicateException((Predicate)p);
        }
    }

    protected void addSubQueryPredicate(SubQueryPredicate p, C parent) {
        if (!(p instanceof ExistsSubQueryPredicate)) {
            throw new UnsupportedPredicateException((Predicate)p);
        }
        this.addExistsSubquery(parent, p.getSubQueryType(), p.getSubQueryPredicate());
    }

    protected static <U extends CriteriaValue<?>> Object getVal(U toConv) {
        Object o = toConv.getValue();
        if (o instanceof DateTime) {
            return new Timestamp(((DateTime)o).getMillis());
        }
        return o;
    }

    protected static <T, U extends CriteriaValue<T>> Set<T> getValsUnsafe(Set<? extends U> toConv) {
        return QueryTranslatorBase.getVals(toConv);
    }

    protected static Set<?> getVals(Set<? extends CriteriaValue<?>> toConv) {
        HashSet<Object> values = new HashSet<Object>();
        for (CriteriaValue<?> value : toConv) {
            values.add(QueryTranslatorBase.getVal(value));
        }
        return values;
    }

    private static Set<String> toUpper(Set<String> strs) {
        HashSet<String> values = new HashSet<String>();
        for (String value : strs) {
            values.add(value.toUpperCase());
        }
        return values;
    }

    protected static class UnsupportedPredicateException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        protected UnsupportedPredicateException(Predicate predicate) {
            super("Unsupported predicate [" + String.valueOf(predicate) + "]");
        }
    }
}

